/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.campolivre;

import java.util.Calendar;
import java.util.Date;
import org.jrimum.bopepo.campolivre.AbstractCLHSBC;
import org.jrimum.bopepo.campolivre.CampoLivreException;
import org.jrimum.bopepo.parametro.ParametroHSBC;
import org.jrimum.domkee.banco.ContaBancaria;
import org.jrimum.domkee.banco.ParametrosBancariosMap;
import org.jrimum.domkee.banco.Titulo;
import org.jrimum.texgit.Fillers;
import org.jrimum.texgit.FixedField;
import org.jrimum.utilix.Exceptions;
import org.jrimum.utilix.Objects;

class CLHSBCCobrancaNaoRegistrada
extends AbstractCLHSBC {
    private static final long serialVersionUID = -1253549781074159862L;
    private static final Integer FIELDS_LENGTH = 4;

    CLHSBCCobrancaNaoRegistrada(Titulo titulo) {
        super(FIELDS_LENGTH);
        this.checkExistsParametrosBancarios(titulo);
        this.checkExistsParametroTipoIdentificadorCNR(titulo.getParametrosBancarios());
        Integer tipoIdentificadorCNR = (Integer)titulo.getParametrosBancarios().getValor(ParametroHSBC.IDENTIFICADOR_CNR);
        ContaBancaria conta = titulo.getContaBancaria();
        String nossoNumero = titulo.getNossoNumero();
        this.add(new FixedField<Integer>(conta.getNumeroDaConta().getCodigoDaConta(), (Integer)7, Fillers.ZERO_LEFT));
        this.add(new FixedField<String>(nossoNumero, (Integer)13, Fillers.ZERO_LEFT));
        this.add(new FixedField<String>(this.getDataVencimentoFormatoJuliano(tipoIdentificadorCNR, titulo.getDataDoVencimento()), (Integer)4, Fillers.ZERO_LEFT));
        this.add(new FixedField<Integer>(Integer.valueOf(2), (Integer)1));
    }

    private String getDataVencimentoFormatoJuliano(Integer tipoIdentificadorCNR, Date vencimento) {
        int SEM_VENCIMENTO = 5;
        int COM_VENCIMENTO = 4;
        switch (tipoIdentificadorCNR) {
            case 5: {
                return "0000";
            }
            case 4: {
                return this.getVencimentoFormatoJuliano(vencimento);
            }
        }
        return (String)Exceptions.throwIllegalStateException("Tipo de identificador CNR desconhecido!");
    }

    private String getVencimentoFormatoJuliano(Date vencimento) {
        Calendar c = Calendar.getInstance();
        c.setTime(vencimento);
        return String.valueOf(c.get(6)) + String.valueOf(c.get(1) % 10);
    }

    private void checkExistsParametrosBancarios(Titulo titulo) {
        if (Objects.isNull(titulo.getParametrosBancarios()) && titulo.getParametrosBancarios().isVazio()) {
            throw new CampoLivreException("Par\u00e2metros banc\u00e1rios nulos em \"Titulo.parametrosBancarios\". O par\u00e2metro banc\u00e1rio de nome e tipo [ IDENTIFICADOR_CNR ] deve ser fornecido para este caso.");
        }
    }

    private void checkExistsParametroTipoIdentificadorCNR(ParametrosBancariosMap parametros) {
        Integer tipoIdentificadorCNR = (Integer)parametros.getValor(ParametroHSBC.IDENTIFICADOR_CNR);
        if (Objects.isNull(tipoIdentificadorCNR)) {
            throw new CampoLivreException("Par\u00e2metro banc\u00e1rio [ IDENTIFICADOR_CNR ] n\u00e3o encontrado em \"Titulo.parametrosBancarios\". O nome do par\u00e2metro deve ser IDENTIFICADOR_CNR.");
        }
    }

    @Override
    protected void addFields(Titulo titulo) {
        Exceptions.throwUnsupportedOperationException("AINDA N\u00c3O IMPLEMENTADO!");
    }

    @Override
    protected void checkValues(Titulo titulo) {
        Exceptions.throwUnsupportedOperationException("AINDA N\u00c3O IMPLEMENTADO!");
    }
}

