/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.campolivre;

import org.jrimum.bopepo.campolivre.AbstractCLItau;
import org.jrimum.domkee.banco.ContaBancaria;
import org.jrimum.domkee.banco.Titulo;
import org.jrimum.texgit.Fillers;
import org.jrimum.texgit.FixedField;
import org.jrimum.utilix.Exceptions;

class CLItauComCarteirasEspeciais
extends AbstractCLItau {
    private static final long serialVersionUID = -1532454262023154419L;
    private static final Integer FIELDS_LENGTH = 6;

    public CLItauComCarteirasEspeciais(Titulo titulo) {
        super(FIELDS_LENGTH);
        ContaBancaria conta = titulo.getContaBancaria();
        this.add(new FixedField<Integer>(conta.getCarteira().getCodigo(), (Integer)3, Fillers.ZERO_LEFT));
        this.add(new FixedField<String>(titulo.getNossoNumero(), (Integer)8, Fillers.ZERO_LEFT));
        this.add(new FixedField<String>(titulo.getNumeroDoDocumento(), (Integer)7, Fillers.ZERO_LEFT));
        this.add(new FixedField<Integer>(conta.getNumeroDaConta().getCodigoDaConta(), (Integer)5, Fillers.ZERO_LEFT));
        this.add(new FixedField<Integer>(this.calculeDigitoDoCampoLivreEspecial(conta.getCarteira().getCodigo(), titulo.getNossoNumero(), titulo.getNumeroDoDocumento(), conta.getNumeroDaConta().getCodigoDaConta()), (Integer)1));
        this.add(new FixedField<Integer>(Integer.valueOf(0), (Integer)1));
    }

    private Integer calculeDigitoDoCampoLivreEspecial(Integer codigoDaCarteira, String nossoNumero, String numeroDoDocumento, Integer codigoDaConta) {
        StringBuilder campo = new StringBuilder();
        campo.append(Fillers.ZERO_LEFT.fill(codigoDaCarteira, 3));
        campo.append(Fillers.ZERO_LEFT.fill(nossoNumero, 8));
        campo.append(Fillers.ZERO_LEFT.fill(numeroDoDocumento, 7));
        campo.append(Fillers.ZERO_LEFT.fill(codigoDaConta, 5));
        return this.calculeDigitoVerificador(campo.toString());
    }

    @Override
    protected void addFields(Titulo titulo) {
        Exceptions.throwUnsupportedOperationException("AINDA N\u00c3O IMPLEMENTADO!");
    }

    @Override
    protected void checkValues(Titulo titulo) {
        Exceptions.throwUnsupportedOperationException("AINDA N\u00c3O IMPLEMENTADO!");
    }
}

