/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.campolivre;

import java.util.Arrays;
import org.jrimum.bopepo.campolivre.AbstractCLItau;
import org.jrimum.domkee.banco.ContaBancaria;
import org.jrimum.domkee.banco.Titulo;
import org.jrimum.texgit.Fillers;
import org.jrimum.texgit.FixedField;
import org.jrimum.utilix.Exceptions;

class CLItauPadrao
extends AbstractCLItau {
    private static final long serialVersionUID = 1544486299245786533L;
    private static final Integer FIELDS_LENGTH = 7;

    public CLItauPadrao(Titulo titulo) {
        super(FIELDS_LENGTH);
        ContaBancaria conta = titulo.getContaBancaria();
        this.add(new FixedField<Integer>(conta.getCarteira().getCodigo(), (Integer)3, Fillers.ZERO_LEFT));
        this.add(new FixedField<String>(titulo.getNossoNumero(), (Integer)8, Fillers.ZERO_LEFT));
        this.add(new FixedField<Integer>(this.calculeDigitoDaPosicao31(conta.getAgencia().getCodigo(), conta.getNumeroDaConta().getCodigoDaConta(), conta.getCarteira().getCodigo(), titulo.getNossoNumero()), (Integer)1));
        this.add(new FixedField<Integer>(conta.getAgencia().getCodigo(), (Integer)4, Fillers.ZERO_LEFT));
        this.add(new FixedField<Integer>(conta.getNumeroDaConta().getCodigoDaConta(), (Integer)5, Fillers.ZERO_LEFT));
        this.add(new FixedField<Integer>(this.calculeDigitoDaPosicao41(conta.getAgencia().getCodigo(), conta.getNumeroDaConta().getCodigoDaConta()), (Integer)1));
        this.add(new FixedField<String>("000", 3));
    }

    private Integer calculeDigitoDaPosicao31(Integer codigoDaAgencia, Integer codigoDaConta, Integer codigoDaCarteira, String nossoNumero) {
        Object[] carteirasEscriturais = new Integer[]{104, 105, 112, 113, 114, 147, 166, 212};
        Object[] carteirasModalidadeDireta = new Integer[]{126, 131, 146, 150, 168};
        StringBuilder campo = new StringBuilder();
        campo.append(Fillers.ZERO_LEFT.fill(codigoDaCarteira, 3));
        campo.append(Fillers.ZERO_LEFT.fill(nossoNumero, 8));
        if (Arrays.binarySearch(carteirasModalidadeDireta, codigoDaCarteira) < 0 && Arrays.binarySearch(carteirasEscriturais, codigoDaCarteira) < 0) {
            campo.insert(0, Fillers.ZERO_LEFT.fill(codigoDaConta, 5));
            campo.insert(0, Fillers.ZERO_LEFT.fill(codigoDaAgencia, 4));
        }
        return this.calculeDigitoVerificador(campo.toString());
    }

    private Integer calculeDigitoDaPosicao41(Integer codigoDaAgencia, Integer codigoDaConta) {
        StringBuilder campo = new StringBuilder();
        campo.append(Fillers.ZERO_LEFT.fill(codigoDaAgencia, 4));
        campo.append(Fillers.ZERO_LEFT.fill(codigoDaConta, 5));
        return this.calculeDigitoVerificador(campo.toString());
    }

    @Override
    protected void addFields(Titulo titulo) {
        Exceptions.throwUnsupportedOperationException("AINDA N\u00c3O IMPLEMENTADO!");
    }

    @Override
    protected void checkValues(Titulo titulo) {
        Exceptions.throwUnsupportedOperationException("AINDA N\u00c3O IMPLEMENTADO!");
    }
}

