/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.campolivre;

import java.math.BigDecimal;
import org.jrimum.bopepo.campolivre.AbstractCLSicredi;
import org.jrimum.bopepo.parametro.ParametroBancoSicredi;
import org.jrimum.domkee.banco.Titulo;
import org.jrimum.texgit.Fillers;
import org.jrimum.texgit.FixedField;
import org.jrimum.utilix.Objects;
import org.jrimum.vallia.Modulo;
import org.jrimum.vallia.TipoDeModulo;

class CLSicredi
extends AbstractCLSicredi {
    private static final long serialVersionUID = 7697120719706717353L;
    private static final Integer FIELDS_LENGTH = 10;
    private static final String COBRANCA_COM_REGISTRO = "1";
    private static final String COBRANCA_SEM_REGISTRO = "3";
    private static final Integer CARTEIRA_SIMPLES_VALUE = 1;
    private static final FixedField<Integer> FIELD_CARTEIRA = new FixedField<Integer>(CARTEIRA_SIMPLES_VALUE, (Integer)1);
    private static final Modulo modulo11 = new Modulo(TipoDeModulo.MODULO11);

    protected CLSicredi() {
        super(FIELDS_LENGTH);
    }

    @Override
    protected void checkValues(Titulo titulo) {
        CLSicredi.checkCarteiraNotNull(titulo);
        CLSicredi.checkCodigoDaCarteira(titulo);
        this.checkCarteiraSimples(titulo);
        CLSicredi.checkRegistroDaCarteiraNotNull(titulo);
        CLSicredi.checkNossoNumero(titulo);
        CLSicredi.checkTamanhoDoNossoNumero(titulo, 8);
        CLSicredi.checkDigitoDoNossoNumero(titulo);
        CLSicredi.checkTamanhoDigitoDoNossoNumero(titulo, 1);
        CLSicredi.checkCodigoDaAgencia(titulo);
        CLSicredi.checkCodigoDaAgenciaMenorOuIgualQue(titulo, 99999);
        CLSicredi.checkParametroBancario(titulo, ParametroBancoSicredi.POSTO_DA_AGENCIA);
        CLSicredi.checkNumeroDaContaNotNull(titulo);
        CLSicredi.checkCodigoDoNumeroDaConta(titulo);
        CLSicredi.checkCodigoDoNumeroDaContaMenorOuIgualQue(titulo, 99999);
        CLSicredi.checkValor(titulo);
    }

    @Override
    protected void addFields(Titulo titulo) {
        if (titulo.getContaBancaria().getCarteira().isComRegistro()) {
            this.add(new FixedField<String>(COBRANCA_COM_REGISTRO, 1));
        } else {
            this.add(new FixedField<String>(COBRANCA_SEM_REGISTRO, 1));
        }
        this.add(FIELD_CARTEIRA);
        this.add(new FixedField<String>(titulo.getNossoNumero(), (Integer)8, Fillers.ZERO_LEFT));
        this.add(new FixedField<String>(titulo.getDigitoDoNossoNumero(), (Integer)1, Fillers.ZERO_LEFT));
        this.add(new FixedField<Integer>(titulo.getContaBancaria().getAgencia().getCodigo(), (Integer)4, Fillers.ZERO_LEFT));
        this.add(new FixedField<Integer>((Integer)titulo.getParametrosBancarios().getValor(ParametroBancoSicredi.POSTO_DA_AGENCIA), (Integer)2, Fillers.ZERO_LEFT));
        this.add(new FixedField<Integer>(titulo.getContaBancaria().getNumeroDaConta().getCodigoDaConta(), (Integer)5, Fillers.ZERO_LEFT));
        if (titulo.getValor().compareTo(BigDecimal.ZERO) == 1) {
            this.add(new FixedField<String>(COBRANCA_COM_REGISTRO, 1));
        } else {
            this.add(new FixedField<String>("0", 1));
        }
        this.add(new FixedField<String>("0", 1));
        this.add(new FixedField<Integer>(this.calculeDigitoVerificador(), (Integer)1));
    }

    private void checkCarteiraSimples(Titulo titulo) {
        Objects.checkArgument(titulo.getContaBancaria().getCarteira().getCodigo().equals(CARTEIRA_SIMPLES_VALUE), String.format("Apenas a carteira de c\u00f3digo [1] \"carteira simples\" \u00e9 permitida e n\u00e3o o c\u00f3digo [%s]!", titulo.getContaBancaria().getCarteira().getCodigo()));
    }

    private Integer calculeDigitoVerificador() {
        int resto = modulo11.calcule(this.writeFields());
        if (resto == 0 || resto == 1) {
            return 0;
        }
        return modulo11.valor() - resto;
    }
}

