/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.campolivre;

import org.apache.commons.lang3.StringUtils;
import org.jrimum.bopepo.campolivre.AbstractCLUnibanco;
import org.jrimum.bopepo.campolivre.CampoLivreException;
import org.jrimum.domkee.banco.ContaBancaria;
import org.jrimum.domkee.banco.Titulo;
import org.jrimum.texgit.Fillers;
import org.jrimum.texgit.FixedField;
import org.jrimum.utilix.Exceptions;
import org.jrimum.utilix.Objects;
import org.jrimum.utilix.Strings;

class CLUnibancoCobrancaNaoRegistrada
extends AbstractCLUnibanco {
    private static final long serialVersionUID = 487906631678160993L;
    private static final Integer FIELDS_LENGTH = 6;
    private static final Integer CODIGO_TRANSACAO = 5;
    private static final Integer RESERVADO = 0;

    CLUnibancoCobrancaNaoRegistrada(Titulo titulo) {
        super(FIELDS_LENGTH);
        Integer digitoDaConta;
        ContaBancaria conta = titulo.getContaBancaria();
        Objects.checkNotNull(conta, "Conta Banc\u00e1ria NULA!");
        Objects.checkNotNull(conta.getNumeroDaConta(), "N\u00famero da Conta Banc\u00e1ria NULO!");
        Objects.checkNotNull(conta.getNumeroDaConta().getCodigoDaConta(), "C\u00f3digo da Conta Banc\u00e1ria NULO!");
        Objects.checkNotNull(conta.getNumeroDaConta().getDigitoDaConta(), "D\u00edgito da Conta Banc\u00e1ria NULO!");
        Objects.checkNotNull(titulo.getNossoNumero(), "Nosso N\u00famero NULO!");
        this.add(new FixedField<Integer>(CODIGO_TRANSACAO, (Integer)1));
        if (conta.getNumeroDaConta().getCodigoDaConta() <= 0) {
            throw new CampoLivreException(new IllegalArgumentException("Conta banc\u00e1ria com valor inv\u00e1lido, a conta deve ser um n\u00famero inteiro positivo, e n\u00e3o: " + conta.getNumeroDaConta().getCodigoDaConta()));
        }
        this.add(new FixedField<Integer>(conta.getNumeroDaConta().getCodigoDaConta(), (Integer)6, Fillers.ZERO_LEFT));
        if (StringUtils.isNumeric((CharSequence)conta.getNumeroDaConta().getDigitoDaConta())) {
            digitoDaConta = Integer.valueOf(conta.getNumeroDaConta().getDigitoDaConta());
            if (digitoDaConta < 0) {
                throw new CampoLivreException(new IllegalArgumentException("O d\u00edgito da conta deve ser um n\u00famero inteiro n\u00e3o-negativo, e n\u00e3o: [" + conta.getNumeroDaConta().getDigitoDaConta() + "]"));
            }
        } else {
            throw new CampoLivreException(new IllegalArgumentException("O d\u00edgito da conta deve ser num\u00e9rico, e n\u00e3o: [" + conta.getNumeroDaConta().getDigitoDaConta() + "]"));
        }
        this.add(new FixedField<Integer>(digitoDaConta, (Integer)1));
        this.add(new FixedField<Integer>(RESERVADO, (Integer)2, Fillers.ZERO_LEFT));
        if (StringUtils.isNumeric((CharSequence)titulo.getNossoNumero())) {
            if (Long.valueOf(Strings.removeStartWithZeros(titulo.getNossoNumero())) <= 0L) {
                throw new CampoLivreException(new IllegalArgumentException("O campo (nosso n\u00famero) do t\u00edtulo deve ser um n\u00famero inteiro positivo, e n\u00e3o: [" + titulo.getNossoNumero() + "]"));
            }
        } else {
            throw new CampoLivreException(new IllegalArgumentException("O campo (nosso n\u00famero) do t\u00edtulo deve ser num\u00e9rico, e n\u00e3o: [" + titulo.getNossoNumero() + "]"));
        }
        this.add(new FixedField<String>(titulo.getNossoNumero(), (Integer)14, Fillers.ZERO_LEFT));
        this.add(new FixedField<String>(this.calculeDigitoEmModulo11(titulo.getNossoNumero()), 1));
    }

    @Override
    protected void addFields(Titulo titulo) {
        Exceptions.throwUnsupportedOperationException("AINDA N\u00c3O IMPLEMENTADO!");
    }

    @Override
    protected void checkValues(Titulo titulo) {
        Exceptions.throwUnsupportedOperationException("AINDA N\u00c3O IMPLEMENTADO!");
    }
}

