/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.campolivre;

import java.text.Format;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.jrimum.bopepo.campolivre.AbstractCLUnibanco;
import org.jrimum.bopepo.campolivre.CampoLivreException;
import org.jrimum.domkee.banco.ContaBancaria;
import org.jrimum.domkee.banco.Titulo;
import org.jrimum.texgit.Fillers;
import org.jrimum.texgit.FixedField;
import org.jrimum.utilix.DateFormat;
import org.jrimum.utilix.Exceptions;
import org.jrimum.utilix.Objects;
import org.jrimum.utilix.Strings;

class CLUnibancoCobrancaRegistrada
extends AbstractCLUnibanco {
    private static final long serialVersionUID = -2740172688796212239L;
    private static final Integer FIELDS_LENGTH = 6;
    private static final String CODIGO_TRANSACAO = "04";

    CLUnibancoCobrancaRegistrada(Titulo titulo) {
        super(FIELDS_LENGTH);
        Integer digitoDaAgencia;
        ContaBancaria conta = titulo.getContaBancaria();
        Objects.checkNotNull(conta, "Conta Banc\u00e1ria NULA!");
        Objects.checkNotNull(titulo.getDataDoVencimento(), "Data de vencimento do t\u00edtulo NULA!");
        Objects.checkNotNull(conta.getAgencia().getCodigo(), "N\u00famero da Ag\u00eancia Banc\u00e1ria NULO!");
        Objects.checkNotNull(conta.getAgencia().getDigitoVerificador(), "D\u00edgito da Ag\u00eancia Banc\u00e1ria NULO!");
        Objects.checkNotNull(titulo.getNossoNumero(), "Nosso N\u00famero NULO!");
        this.add(new FixedField<String>(CODIGO_TRANSACAO, 2));
        this.add(new FixedField<Date>(titulo.getDataDoVencimento(), (Integer)6, (Format)DateFormat.YYMMDD.copy()));
        if (conta.getAgencia().getCodigo() <= 0) {
            throw new CampoLivreException(new IllegalArgumentException("Ag\u00eancia banc\u00e1ria com valor inv\u00e1lido, a ag\u00eancia deve ser um n\u00famero inteiro positivo, e n\u00e3o: " + conta.getNumeroDaConta().getCodigoDaConta()));
        }
        this.add(new FixedField<Integer>(conta.getAgencia().getCodigo(), (Integer)4, Fillers.ZERO_LEFT));
        if (StringUtils.isNumeric((CharSequence)conta.getAgencia().getDigitoVerificador())) {
            digitoDaAgencia = Integer.valueOf(conta.getAgencia().getDigitoVerificador());
            if (digitoDaAgencia < 0) {
                throw new CampoLivreException(new IllegalArgumentException("O d\u00edgito da ag\u00eancia deve ser um n\u00famero interio n\u00e3o-negativo, e n\u00e3o: [" + conta.getAgencia().getDigitoVerificador() + "]"));
            }
        } else {
            throw new CampoLivreException(new IllegalArgumentException("O d\u00edgito da ag\u00eancia deve ser num\u00e9rico, e n\u00e3o: [" + conta.getAgencia().getDigitoVerificador() + "]"));
        }
        this.add(new FixedField<Integer>(digitoDaAgencia, (Integer)1));
        if (StringUtils.isNumeric((CharSequence)titulo.getNossoNumero())) {
            if (Long.valueOf(Strings.removeStartWithZeros(titulo.getNossoNumero())) <= 0L) {
                throw new CampoLivreException(new IllegalArgumentException("O campo (nosso n\u00famero) do t\u00edtulo deve ser um n\u00famero natural positivo, e n\u00e3o: [" + titulo.getNossoNumero() + "]"));
            }
        } else {
            throw new CampoLivreException(new IllegalArgumentException("O campo (nosso n\u00famero) do t\u00edtulo deve ser num\u00e9rico, e n\u00e3o: [" + titulo.getNossoNumero() + "]"));
        }
        this.add(new FixedField<String>(titulo.getNossoNumero(), (Integer)11, Fillers.ZERO_LEFT));
        this.add(new FixedField<String>(this.calculeSuperDigito(titulo.getNossoNumero()), 1));
    }

    private String calculeSuperDigito(String nossoNumero) {
        return this.calculeDigitoEmModulo11("1" + nossoNumero);
    }

    @Override
    protected void addFields(Titulo titulo) {
        Exceptions.throwUnsupportedOperationException("AINDA N\u00c3O IMPLEMENTADO!");
    }

    @Override
    protected void checkValues(Titulo titulo) {
        Exceptions.throwUnsupportedOperationException("AINDA N\u00c3O IMPLEMENTADO!");
    }
}

