/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.campolivre;

import org.apache.commons.lang3.StringUtils;
import org.jrimum.bopepo.campolivre.AbstractCampoLivre;
import org.jrimum.bopepo.campolivre.CampoLivre;
import org.jrimum.bopepo.campolivre.NotSupportedBancoException;
import org.jrimum.bopepo.campolivre.NotSupportedCampoLivreException;
import org.jrimum.domkee.banco.Titulo;
import org.jrimum.texgit.Fillers;
import org.jrimum.texgit.FixedField;
import org.jrimum.utilix.Objects;
import org.jrimum.utilix.Strings;

public final class CampoLivreFactory {
    public static CampoLivre create(Titulo titulo) throws NotSupportedBancoException, NotSupportedCampoLivreException {
        return AbstractCampoLivre.create(titulo);
    }

    public static CampoLivre create(String strCampoLivre) {
        Objects.checkNotNull(strCampoLivre);
        strCampoLivre = StringUtils.strip((String)strCampoLivre);
        Strings.checkNotBlank(strCampoLivre, "O Campo Livre n\u00e3o deve ser vazio!");
        Objects.checkArgument(strCampoLivre.length() == CampoLivre.STRING_LENGTH.intValue(), "O tamanho do Campo Livre [ " + strCampoLivre + " ] deve ser igual a 25 e n\u00e3o [" + strCampoLivre.length() + "]!");
        Objects.checkArgument(!StringUtils.containsAny((CharSequence)strCampoLivre, (CharSequence)" "), "O Campo Livre [ " + strCampoLivre + " ] n\u00e3o deve conter espa\u00e7os em branco!");
        Objects.checkArgument(StringUtils.isNumeric((CharSequence)strCampoLivre), "O Campo Livre [ " + strCampoLivre + " ] deve ser uma String num\u00e9rica!");
        return CampoLivreFactory.valueOf(strCampoLivre);
    }

    private static CampoLivre valueOf(String strCampoLivre) {
        CampoLivre campoLivre = new CampoLivre(){
            private static final long serialVersionUID = -7592488081807235080L;
            FixedField<String> campo = new FixedField<String>("", STRING_LENGTH, Fillers.ZERO_LEFT);

            @Override
            public void read(String str) {
                this.campo.read(str);
            }

            @Override
            public String write() {
                return this.campo.write();
            }
        };
        campoLivre.read(strCampoLivre);
        return campoLivre;
    }

    public String toString() {
        return Objects.toString(this);
    }
}

