/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.campolivre;

import org.apache.commons.lang3.StringUtils;
import org.jrimum.bopepo.campolivre.CampoLivre;
import org.jrimum.bopepo.campolivre.CampoLivreException;
import org.jrimum.domkee.banco.TipoSeguimento;

public class CampoLivreUtil {
    public static Integer getTamanhoCorreto(TipoSeguimento tipoSeguimento) {
        Integer tamanhoCorreto = null;
        tamanhoCorreto = tipoSeguimento == TipoSeguimento.CARNES_E_ASSEMELHADOS_OU_DEMAIS ? Integer.valueOf(21) : Integer.valueOf(25);
        return tamanhoCorreto;
    }

    public static boolean tamanhoEstaCorreto(CampoLivre campoLivre, TipoSeguimento tipoSeguimento) {
        return CampoLivreUtil.tamanhoEstaCorreto((String)campoLivre.write(), tipoSeguimento);
    }

    public static boolean tamanhoEstaCorreto(String campoLivreStr, TipoSeguimento tipoSeguimento) {
        return campoLivreStr.length() == CampoLivreUtil.getTamanhoCorreto(tipoSeguimento).intValue();
    }

    public static boolean existeEspacoEmBranco(CampoLivre campoLivre, TipoSeguimento tipoSeguimento) {
        return CampoLivreUtil.existeEspacoEmBranco((String)campoLivre.write(), tipoSeguimento);
    }

    public static boolean existeEspacoEmBranco(String campoLivreStr, TipoSeguimento tipoSeguimento) {
        int tamanhoAtual = campoLivreStr.length();
        return StringUtils.remove((String)campoLivreStr, (char)' ').length() != tamanhoAtual;
    }

    public static boolean naoExisteEspacoEmBranco(CampoLivre campoLivre, TipoSeguimento tipoSeguimento) {
        return CampoLivreUtil.naoExisteEspacoEmBranco((String)campoLivre.write(), tipoSeguimento);
    }

    public static boolean naoExisteEspacoEmBranco(String campoLivreStr, TipoSeguimento tipoSeguimento) {
        return StringUtils.remove((String)campoLivreStr, (char)' ').length() == CampoLivreUtil.getTamanhoCorreto(tipoSeguimento).intValue();
    }

    public static void validar(CampoLivre campoLivre, TipoSeguimento tipoSeguimento) throws CampoLivreException {
        int tamanhoAtual = ((String)campoLivre.write()).length();
        int tamanhoEsperado = CampoLivreUtil.getTamanhoCorreto(tipoSeguimento);
        StringBuilder msgErro = new StringBuilder();
        if (!CampoLivreUtil.tamanhoEstaCorreto(campoLivre, tipoSeguimento)) {
            if (tamanhoAtual > tamanhoEsperado) {
                msgErro.append("O tamanho do campo livre gerado [" + tamanhoAtual + "] \u00e9 maior que o esperado [" + tamanhoEsperado + "] para o segmento \"" + tipoSeguimento.getCodigo() + "-" + tipoSeguimento.getDescricao() + "\".");
            } else {
                msgErro.append("O tamanho do campo livre gerado [" + tamanhoAtual + "] \u00e9 menor que o esperado [" + tamanhoEsperado + "] para o segmento \"" + tipoSeguimento.getCodigo() + "-" + tipoSeguimento.getDescricao() + "\".");
            }
        }
        if (CampoLivreUtil.existeEspacoEmBranco(campoLivre, tipoSeguimento)) {
            msgErro.append("O campo livre possui espa\u00e7os em branco, e isto n\u00e3o pode ocorrer.");
        }
        if (msgErro.length() > 0) {
            throw new CampoLivreException(msgErro.toString());
        }
    }
}

