/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.pdf;

import com.itextpdf.text.pdf.BarcodeInter25;
import java.awt.Color;
import java.awt.Image;
import org.jrimum.utilix.Exceptions;
import org.jrimum.utilix.Objects;
import org.jrimum.utilix.Strings;

public class CodigoDeBarras {
    private String codigo;

    private CodigoDeBarras() {
        Exceptions.throwIllegalStateException("Instancia\u00e7\u00e3o n\u00e3o permitida!");
    }

    public CodigoDeBarras(String codigo) {
        CodigoDeBarras.checkCodigo(codigo);
        this.codigo = codigo;
    }

    public static CodigoDeBarras valueOf(String codigo) {
        CodigoDeBarras.checkCodigo(codigo);
        return new CodigoDeBarras(codigo);
    }

    public String write() {
        return this.codigo;
    }

    public Image toImage() {
        BarcodeInter25 barCode = new BarcodeInter25();
        barCode.setCode(this.write());
        barCode.setExtended(true);
        barCode.setBarHeight(35.0f);
        barCode.setFont(null);
        barCode.setN(3.0f);
        return barCode.createAwtImage(Color.BLACK, Color.WHITE);
    }

    private static void checkCodigo(String str) {
        Objects.checkNotNull(str, "C\u00f3digo nulo!");
        Strings.checkNotBlank(str, String.format("C\u00f3digo ausente! str = \"%s\"", str));
        Strings.checkNotNumeric(str, String.format("C\u00f3digo n\u00e3o cont\u00e9m apenas n\u00fameros! str = \"%s\"", str));
        Objects.checkArgument(str.length() == 44, String.format("C\u00f3digo com tamanho diferente de 44 d\u00edgitos! str = \"%s\"", str));
    }
}

