/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.pdf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jrimum.utilix.Exceptions;
import org.jrimum.utilix.Objects;
import org.jrimum.utilix.Strings;

public class Files {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final String ZIP_SUFFIX = ".zip";

    private Files() {
        Exceptions.throwIllegalStateException("Instancia\u00e7\u00e3o n\u00e3o permitida!");
    }

    public static File bytesToFile(String pathName, byte[] bytes) throws FileNotFoundException, IOException {
        Strings.checkNotBlank(pathName);
        Objects.checkNotNull(bytes);
        return Files.bytesToFile(new File(pathName), bytes);
    }

    public static File bytesToFile(File file, byte[] bytes) throws FileNotFoundException, IOException {
        Objects.checkNotNull(file);
        Objects.checkNotNull(bytes);
        if (file.length() > Integer.MAX_VALUE) {
            Exceptions.throwIllegalArgumentException("TAMANHO DO ARQUIVO MAIOR DO QUE O SUPORTADO: 2147483647");
        }
        FileOutputStream out = new FileOutputStream(file);
        ((OutputStream)out).write(bytes);
        out.flush();
        ((OutputStream)out).close();
        return file;
    }

    public static ByteArrayOutputStream bytesToStream(byte[] bytes) throws IOException {
        Objects.checkNotNull(bytes);
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        byteOut.write(bytes);
        return byteOut;
    }

    public static byte[] fileToBytes(File file) throws IOException {
        int offset;
        Objects.checkNotNull(file);
        FileInputStream is = new FileInputStream(file);
        byte[] bytes = new byte[(int)file.length()];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        ((InputStream)is).close();
        Objects.checkArgument(offset == bytes.length, "N\u00e3o foi poss\u00edvel completar a leitura do arquivo: " + file.getName());
        return bytes;
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        Objects.checkNotNull(input);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        input.close();
        output.flush();
        return output.toByteArray();
    }

    public static File zip(File f) {
        return Files.zip(f.getName(), f);
    }

    public static File zip(String zipedName, File f) {
        try {
            return Files.bytesToFile(File.createTempFile(zipedName, ZIP_SUFFIX), Files.zip(Files.toByteArray(f), f.getName()));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] zip(byte[] fileToZip, String fileZipedName) {
        ByteArrayOutputStream obout = new ByteArrayOutputStream();
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(obout);
            out.setMethod(8);
            out.putNextEntry(new ZipEntry(fileZipedName));
            out.write(fileToZip);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    return (byte[])Exceptions.throwIllegalStateException(e);
                }
            }
        }
        return obout.toByteArray();
    }

    public static File zip(Collection<File> files) {
        WeakHashMap<String, File> toZip = new WeakHashMap<String, File>(files.size());
        for (File f : files) {
            toZip.put(f.getName(), f);
        }
        return Files.zip(toZip);
    }

    public static File zip(Map<String, File> files) {
        return Files.zip("ZipedFiles", files);
    }

    public static File zip(String zipedName, Map<String, File> files) {
        HashMap<String, byte[]> bytFiles = new HashMap<String, byte[]>(files.size());
        for (Map.Entry<String, File> nameAndFile : files.entrySet()) {
            bytFiles.put(nameAndFile.getKey(), Files.toByteArray(nameAndFile.getValue()));
        }
        try {
            return Files.bytesToFile(File.createTempFile(zipedName, ZIP_SUFFIX), Files.zipBytes(bytFiles));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] zipBytes(Map<String, byte[]> files) {
        byte[] buf = new byte[4096];
        ByteArrayOutputStream outs = new ByteArrayOutputStream();
        try {
            ZipOutputStream out = new ZipOutputStream(outs);
            for (Map.Entry<String, byte[]> entry : files.entrySet()) {
                int len;
                if (entry.getValue() == null) continue;
                ByteArrayInputStream in = new ByteArrayInputStream(entry.getValue());
                out.putNextEntry(new ZipEntry(Files.normalizeName(entry.getKey())));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
            }
            out.close();
            return outs.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] toByteArray(File file) {
        try {
            int offset;
            FileInputStream is = new FileInputStream(file);
            long length = file.length();
            if (length > Integer.MAX_VALUE) {
                Exceptions.throwIllegalArgumentException(String.format("File is too large! Max file length capacity is %s bytes.", length));
            }
            byte[] bytes = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            ((InputStream)is).close();
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
            return bytes;
        }
        catch (Exception e) {
            return (byte[])Exceptions.throwIllegalStateException(e);
        }
    }

    public static String normalizeName(String name) {
        name = name.replaceAll(" ", "_");
        name = Strings.eliminateAccent(name);
        name = name.replaceAll("[^\\p{ASCII}]", "");
        return name;
    }
}

