/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.pdf;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Image;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.jrimum.bopepo.pdf.PdfDocInfo;
import org.jrimum.bopepo.pdf.PdfRectangle;
import org.jrimum.utilix.Exceptions;

public class PDFs {
    public static PdfRectangle changeFieldToImage(PdfStamper stamper, float[] positions, Image image) throws DocumentException {
        PdfRectangle rect = new PdfRectangle(positions);
        return PDFs.changeFieldToImage(stamper, rect, image);
    }

    public static PdfRectangle changeFieldToImage(PdfStamper stamper, PdfRectangle rect, Image image) throws DocumentException {
        image.scaleAbsolute(rect.getWidth(), rect.getHeight());
        image.setAbsolutePosition(rect.getLowerLeftX() + (rect.getWidth() - image.getScaledWidth()) / 2.0f, rect.getLowerLeftY() + (rect.getHeight() - image.getScaledHeight()) / 2.0f);
        int page = rect.getPage();
        PdfContentByte overContent = stamper.getOverContent(page);
        if (overContent == null) {
            overContent = stamper.getOverContent(page + 1);
        }
        overContent.addImage(image);
        return rect;
    }

    public static byte[] mergeFiles(Collection<byte[]> pdfFiles) {
        return PDFs.mergeFiles(pdfFiles, null);
    }

    public static byte[] mergeFiles(Collection<byte[]> pdfFiles, PdfDocInfo info) {
        try {
            ByteArrayOutputStream byteOS = new ByteArrayOutputStream();
            Document document = new Document();
            PdfCopy copy = new PdfCopy(document, (OutputStream)byteOS);
            document.open();
            for (byte[] f : pdfFiles) {
                PdfReader reader = new PdfReader(f);
                for (int page = 1; page <= reader.getNumberOfPages(); ++page) {
                    copy.addPage(copy.getImportedPage(reader, page));
                }
                reader.close();
            }
            document.addCreationDate();
            if (info != null) {
                document.addAuthor(info.author());
                document.addCreator(info.creator());
                document.addTitle(info.title());
                document.addSubject(info.subject());
                document.addKeywords(info.keywords());
            }
            copy.close();
            document.close();
            byteOS.close();
            return byteOS.toByteArray();
        }
        catch (Exception e) {
            return (byte[])Exceptions.throwIllegalStateException(e);
        }
    }
}

