/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.pdf;

import java.util.Calendar;
import java.util.TimeZone;
import org.jrimum.texgit.Fillers;
import org.jrimum.utilix.Objects;

public class PdfDateConverter {
    public static String convert(Calendar date) {
        Objects.checkNotNull(date, "Null n\u00e3o pode ser convertido em uma data no formato PDF!");
        boolean NOT_INDEX = true;
        StringBuilder dateTime = new StringBuilder("D:").append(date.get(1)).append(Fillers.ZERO_LEFT.fill(date.get(2) + 1, 2)).append(Fillers.ZERO_LEFT.fill(date.get(5), 2)).append(Fillers.ZERO_LEFT.fill(date.get(11), 2)).append(Fillers.ZERO_LEFT.fill(date.get(12), 2)).append(Fillers.ZERO_LEFT.fill(date.get(13), 2)).append(PdfDateConverter.convertTimeZone(date));
        return dateTime.toString();
    }

    private static String convertTimeZone(Calendar date) {
        int MINUTES_PER_HOUR = 60;
        int MILLISECONDS_PER_SECOND = 1000;
        int SECONDS_PER_MINUTE = 60;
        TimeZone tz = date.getTimeZone();
        String timeZone = "Z00'00'";
        if (Objects.isNotNull(tz)) {
            long offset = tz.getOffset(date.getTimeInMillis());
            long timeInMinutes = Math.abs(offset) / 1000L / 60L;
            String signal = offset == 0L ? "Z" : (offset > 0L ? "+" : "-");
            long hours = 0L;
            long minutes = 0L;
            if (timeInMinutes > 60L) {
                hours = timeInMinutes / 60L;
                minutes = timeInMinutes % 60L;
            } else {
                minutes = timeInMinutes;
            }
            timeZone = String.format("%1$s%2$02d'%3$02d'", signal, hours, minutes);
        }
        return timeZone;
    }
}

