/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.pdf;

import com.itextpdf.text.pdf.PdfDate;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.jrimum.bopepo.pdf.PdfDateConverter;
import org.jrimum.utilix.Exceptions;
import org.jrimum.utilix.Objects;

public class PdfDocInfo {
    private static final String DOC_TITLE = "Title";
    private static final String DOC_AUTHOR = "Author";
    private static final String DOC_SUBJECT = "Subject";
    private static final String DOC_KEYWORDS = "Keywords";
    private static final String DOC_CREATOR = "Creator";
    private static final String DOC_CREATION_DATE = "CreationDate";
    private static final String DOC_MODIFACTION_DATE = "ModDate";
    private static final String DOC_PRODUCER = "Producer";
    private final Map<String, String> docInfo;

    private PdfDocInfo() {
        Exceptions.throwIllegalStateException("Estado n\u00e3o permitido!");
        this.docInfo = null;
    }

    private PdfDocInfo(Map<String, String> info) {
        Objects.checkNotNull(info);
        this.docInfo = info;
    }

    public static PdfDocInfo create() {
        return new PdfDocInfo(new HashMap<String, String>(8));
    }

    public static PdfDocInfo create(Map<String, String> info) {
        Objects.checkNotNull(info, "INFO INV\u00c1LIDA!");
        return new PdfDocInfo(info);
    }

    public PdfDocInfo title(String title) {
        if (Objects.isNotNull(title)) {
            this.docInfo.put(DOC_TITLE, title);
        }
        return this;
    }

    public PdfDocInfo author(String author) {
        if (Objects.isNotNull(author)) {
            this.docInfo.put(DOC_AUTHOR, author);
        }
        return this;
    }

    public PdfDocInfo subject(String subject) {
        if (Objects.isNotNull(subject)) {
            this.docInfo.put(DOC_SUBJECT, subject);
        }
        return this;
    }

    public PdfDocInfo keywords(String keywords) {
        if (Objects.isNotNull(keywords)) {
            this.docInfo.put(DOC_KEYWORDS, keywords);
        }
        return this;
    }

    public PdfDocInfo creator(String creator) {
        if (Objects.isNotNull(creator)) {
            this.docInfo.put(DOC_CREATOR, creator);
        }
        return this;
    }

    public PdfDocInfo creation(Calendar date) {
        Objects.checkNotNull(date, "Valor null n\u00e3o permitido para data de cria\u00e7\u00e3o do documento!");
        this.docInfo.put(DOC_CREATION_DATE, PdfDateConverter.convert(date));
        return this;
    }

    public PdfDocInfo modification(Calendar date) {
        Objects.checkNotNull(date, "Valor null n\u00e3o permitido para data de modifica\u00e7\u00e3o do documento!");
        Objects.checkNotNull(date);
        this.docInfo.put(DOC_MODIFACTION_DATE, PdfDateConverter.convert(date));
        return this;
    }

    public String title() {
        return this.docInfo.get(DOC_TITLE);
    }

    public String author() {
        return this.docInfo.get(DOC_AUTHOR);
    }

    public String subject() {
        return this.docInfo.get(DOC_SUBJECT);
    }

    public String keywords() {
        return this.docInfo.get(DOC_KEYWORDS);
    }

    public String creator() {
        return this.docInfo.get(DOC_CREATOR);
    }

    public String creationRaw() {
        return this.docInfo.get(DOC_CREATION_DATE);
    }

    public Calendar creation() {
        return PdfDate.decode((String)this.docInfo.get(DOC_CREATION_DATE));
    }

    public String modificationRaw() {
        return this.docInfo.get(DOC_MODIFACTION_DATE);
    }

    public Calendar modification() {
        return PdfDate.decode((String)this.docInfo.get(DOC_MODIFACTION_DATE));
    }

    public String producer() {
        return this.docInfo.get(DOC_PRODUCER);
    }

    public Map<String, String> toMap() {
        return new HashMap<String, String>(this.docInfo);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.docInfo == null ? 0 : this.docInfo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PdfDocInfo other = (PdfDocInfo)obj;
        return !(this.docInfo == null ? other.docInfo != null : !this.docInfo.equals(other.docInfo));
    }

    public String toString() {
        return "PdfDocInfo [docInfo=" + this.docInfo + "]";
    }
}

