/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.pdf;

import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.PdfBoolean;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jrimum.bopepo.pdf.Files;
import org.jrimum.bopepo.pdf.PDFs;
import org.jrimum.bopepo.pdf.PdfDocInfo;
import org.jrimum.bopepo.pdf.PdfRectangle;
import org.jrimum.utilix.Collections;
import org.jrimum.utilix.Exceptions;
import org.jrimum.utilix.Objects;
import org.jrimum.utilix.Strings;

public class PdfDocMix {
    private static final Logger LOG = Logger.getLogger(PdfDocMix.class);
    private PdfReader reader;
    private PdfStamper stamper;
    private AcroFields form;
    private ByteArrayOutputStream outputStream;
    private Map<Image, com.itextpdf.text.Image> imagesInUseMap = new WeakHashMap<Image, com.itextpdf.text.Image>();
    private byte[] template;
    private PdfDocInfo docInfo = PdfDocInfo.create();
    private Map<String, String> txtMap;
    private Map<String, Image> imgMap;
    private boolean fullCompression = true;
    private boolean removeFields = true;
    private Boolean displayDocTitle;

    private PdfDocMix() {
    }

    public PdfDocMix(byte[] template) {
        PdfDocMix.checkTemplateFile(template);
        this.setTemplate(template);
    }

    public PdfDocMix(URL templateUrl) {
        PdfDocMix.checkTemplateFile(templateUrl);
        this.setTemplate(templateUrl);
    }

    public PdfDocMix(InputStream templateInput) {
        PdfDocMix.checkTemplateFile(templateInput);
        this.setTemplate(templateInput);
    }

    public PdfDocMix(String templatePath) {
        PdfDocMix.checkTemplatePath(templatePath);
        this.setTemplate(templatePath);
    }

    public PdfDocMix(File templateFile) {
        PdfDocMix.checkTemplateFile(templateFile);
        this.setTemplate(templateFile);
    }

    public static PdfDocMix create() {
        return new PdfDocMix();
    }

    public static PdfDocMix createWithTemplate(byte[] template) {
        PdfDocMix.checkTemplateFile(template);
        return new PdfDocMix(template);
    }

    public static PdfDocMix createWithTemplate(URL templateUrl) {
        PdfDocMix.checkTemplateFile(templateUrl);
        return new PdfDocMix(templateUrl);
    }

    public static PdfDocMix createWithTemplate(InputStream templateInput) {
        PdfDocMix.checkTemplateFile(templateInput);
        return new PdfDocMix(templateInput);
    }

    public static PdfDocMix createWithTemplate(String templatePath) {
        PdfDocMix.checkTemplatePath(templatePath);
        return new PdfDocMix(templatePath);
    }

    public static PdfDocMix createWithTemplate(File templateFile) {
        PdfDocMix.checkTemplateFile(templateFile);
        return new PdfDocMix(templateFile);
    }

    public PdfDocMix withTemplate(byte[] template) {
        PdfDocMix.checkTemplateFile(template);
        return this.setTemplate(template);
    }

    public PdfDocMix withTemplate(URL templateUrl) {
        PdfDocMix.checkTemplateFile(templateUrl);
        return this.setTemplate(templateUrl);
    }

    public PdfDocMix withTemplate(InputStream templateInput) {
        PdfDocMix.checkTemplateFile(templateInput);
        return this.setTemplate(templateInput);
    }

    public PdfDocMix withTemplate(String templatePath) {
        PdfDocMix.checkTemplatePath(templatePath);
        return this.setTemplate(templatePath);
    }

    public PdfDocMix withTemplate(File templateFile) {
        PdfDocMix.checkTemplateFile(templateFile);
        return this.setTemplate(templateFile);
    }

    public Map<String, String> getTextFields() {
        return this.txtMap;
    }

    public PdfDocMix putAllTexts(Map<String, String> txtMap) {
        Collections.checkNotEmpty(txtMap, "Campos ausentes!");
        if (Objects.isNull(this.txtMap)) {
            this.txtMap = txtMap;
        } else {
            this.txtMap.putAll(txtMap);
        }
        return this;
    }

    public PdfDocMix put(String name, String value) {
        Strings.checkNotBlank(name, "Nome do campo ausente!");
        if (Objects.isNull(this.txtMap)) {
            this.txtMap = new WeakHashMap<String, String>();
        }
        this.txtMap.put(name, value);
        return this;
    }

    public Map<String, Image> getImageFields() {
        return this.imgMap;
    }

    public PdfDocMix putAllImages(Map<String, Image> imgMap) {
        Collections.checkNotEmpty(imgMap, "Campos ausentes!");
        if (Objects.isNull(this.imgMap)) {
            this.imgMap = imgMap;
        } else {
            this.imgMap.putAll(imgMap);
        }
        return this;
    }

    public PdfDocMix put(String name, Image value) {
        Strings.checkNotBlank(name, "Nome do campo ausente!");
        if (Objects.isNull(this.imgMap)) {
            this.imgMap = new WeakHashMap<String, Image>();
        }
        this.imgMap.put(name, value);
        return this;
    }

    public PdfDocMix withFullCompression(boolean option) {
        this.fullCompression = option;
        return this;
    }

    public PdfDocMix removeFields(boolean option) {
        this.removeFields = option;
        return this;
    }

    public PdfDocMix withTitle(String title) {
        this.docInfo.title(title);
        return this;
    }

    public PdfDocMix withAuthor(String author) {
        this.docInfo.author(author);
        return this;
    }

    public PdfDocMix withSubject(String subject) {
        this.docInfo.subject(subject);
        return this;
    }

    public PdfDocMix withKeywords(String keywords) {
        this.docInfo.keywords(keywords);
        return this;
    }

    public PdfDocMix withCreator(String creator) {
        this.docInfo.creator(creator);
        return this;
    }

    public PdfDocMix withCreation(Calendar date) {
        this.docInfo.creation(date);
        return this;
    }

    public PdfDocMix withDocInfo(PdfDocInfo docInfo) {
        Objects.checkNotNull(docInfo, "Valor null para docInfo n\u00e3o permitido!");
        this.docInfo = docInfo;
        return this;
    }

    public PdfDocMix withDisplayDocTilteOption(boolean option) {
        this.displayDocTitle = option;
        return this;
    }

    public File toFile(String destPath) {
        PdfDocMix.checkDestPath(destPath);
        return this.toFile(new File(destPath));
    }

    public File toFile(URL destURL) {
        PdfDocMix.checkDestURL(destURL);
        try {
            return this.toFile(new File(destURL.toURI()));
        }
        catch (Exception e) {
            LOG.error((Object)("Erro durante a cria\u00e7\u00e3o do arquivo! " + e.getLocalizedMessage()), (Throwable)e);
            return (File)Exceptions.throwIllegalStateException("Erro ao tentar criar arquivo! Causado por " + e.getLocalizedMessage(), e);
        }
    }

    public File toFile(File destFile) {
        PdfDocMix.checkDestFile(destFile);
        try {
            this.process();
            return Files.bytesToFile(destFile, this.outputStream.toByteArray());
        }
        catch (Exception e) {
            LOG.error((Object)("Erro durante a cria\u00e7\u00e3o do arquivo! " + e.getLocalizedMessage()), (Throwable)e);
            return (File)Exceptions.throwIllegalStateException("Erro ao tentar criar arquivo! Causado por " + e.getLocalizedMessage(), e);
        }
    }

    public ByteArrayOutputStream toStream() {
        try {
            this.process();
            return Files.bytesToStream(this.outputStream.toByteArray());
        }
        catch (Exception e) {
            LOG.error((Object)("Erro durante a cria\u00e7\u00e3o do stream! " + e.getLocalizedMessage()), (Throwable)e);
            return (ByteArrayOutputStream)Exceptions.throwIllegalStateException("Erro durante a cria\u00e7\u00e3o do stream! Causado por " + e.getLocalizedMessage(), e);
        }
    }

    public byte[] toBytes() {
        try {
            this.process();
            return this.outputStream.toByteArray();
        }
        catch (Exception e) {
            LOG.error((Object)("Erro durante a cria\u00e7\u00e3o do array de bytes! " + e.getLocalizedMessage()), (Throwable)e);
            return (byte[])Exceptions.throwIllegalStateException("Erro durante a cria\u00e7\u00e3o do array de bytes! Causado por " + e.getLocalizedMessage(), e);
        }
    }

    public byte[] getTemplate() {
        return (byte[])this.template.clone();
    }

    private PdfDocMix setTemplate(byte[] template) {
        this.template = template;
        return this;
    }

    private PdfDocMix setTemplate(URL templateUrl) {
        try {
            this.setTemplate(templateUrl.openStream());
            return this;
        }
        catch (Exception e) {
            return (PdfDocMix)Exceptions.throwIllegalStateException(e);
        }
    }

    private PdfDocMix setTemplate(InputStream templateInput) {
        try {
            this.setTemplate(Files.toByteArray(templateInput));
            return this;
        }
        catch (Exception e) {
            return (PdfDocMix)Exceptions.throwIllegalStateException(e);
        }
    }

    private PdfDocMix setTemplate(String templatePath) {
        this.setTemplate(new File(templatePath));
        return this;
    }

    private PdfDocMix setTemplate(File templateFile) {
        try {
            this.setTemplate(Files.fileToBytes(templateFile));
            return this;
        }
        catch (Exception e) {
            return (PdfDocMix)Exceptions.throwIllegalStateException(e);
        }
    }

    private boolean isFullCompression() {
        return this.fullCompression;
    }

    private boolean isRemoveFields() {
        return this.removeFields;
    }

    private void process() {
        this.init();
        this.fillFields();
        this.end();
    }

    private void init() {
        try {
            this.reader = new PdfReader(this.getTemplate());
            this.outputStream = new ByteArrayOutputStream();
            this.stamper = new PdfStamper(this.reader, (OutputStream)this.outputStream);
            String JRIMUM = "jrimum.org/bopepo";
            String creator = this.docInfo.creator();
            if (StringUtils.isBlank((CharSequence)creator)) {
                this.withCreator("jrimum.org/bopepo");
            } else {
                this.withCreator(creator + " by (jrimum.org/bopepo)");
            }
            if (Objects.isNull(this.docInfo.creation())) {
                this.docInfo.creation(Calendar.getInstance());
            }
            this.stamper.setMoreInfo((Map)((HashMap)this.docInfo.toMap()));
            if (Objects.isNotNull(this.displayDocTitle)) {
                this.stamper.addViewerPreference(PdfName.DISPLAYDOCTITLE, (PdfObject)(this.displayDocTitle != false ? PdfBoolean.PDFTRUE : PdfBoolean.PDFFALSE));
            }
            this.stamper.addViewerPreference(PdfName.NEEDAPPEARANCES, (PdfObject)PdfBoolean.PDFTRUE);
            this.form = this.stamper.getAcroFields();
            this.form.setGenerateAppearances(true);
        }
        catch (Exception e) {
            Exceptions.throwIllegalStateException(e);
        }
    }

    private void fillFields() {
        this.setTextFields();
        this.setImageFields();
    }

    private void setTextFields() {
        if (Collections.hasElement(this.txtMap)) {
            for (Map.Entry<String, String> e : this.txtMap.entrySet()) {
                try {
                    this.form.setField(e.getKey(), e.getValue());
                }
                catch (Exception ex) {
                    Exceptions.throwIllegalStateException(ex);
                }
            }
        }
    }

    private void setImageFields() {
        if (Collections.hasElement(this.imgMap)) {
            for (Map.Entry<String, Image> e : this.imgMap.entrySet()) {
                this.setImage(e.getKey(), e.getValue());
            }
        }
    }

    private void setImage(String fieldName, Image image) {
        if (StringUtils.isNotBlank((CharSequence)fieldName)) {
            List posImgField = this.form.getFieldPositions(fieldName);
            if (Objects.isNotNull(posImgField)) {
                try {
                    for (AcroFields.FieldPosition pos : posImgField) {
                        PDFs.changeFieldToImage(this.stamper, new PdfRectangle(pos.position), this.getPdfImage(image));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Exceptions.throwIllegalStateException(e);
                }
            } else {
                LOG.warn((Object)("Posicionamento do campo de imagem nao encontrado! CAMPO: " + fieldName));
            }
        }
    }

    public com.itextpdf.text.Image getPdfImage(Image image) {
        com.itextpdf.text.Image pdfImage = this.imagesInUseMap.get(image);
        if (Objects.isNull(pdfImage)) {
            try {
                pdfImage = com.itextpdf.text.Image.getInstance((Image)image, null);
                this.imagesInUseMap.put(image, pdfImage);
            }
            catch (Exception ex) {
                Exceptions.throwIllegalStateException(ex);
            }
        }
        return pdfImage;
    }

    private void end() {
        if (this.isRemoveFields()) {
            this.stamper.setFreeTextFlattening(true);
            this.stamper.setFormFlattening(true);
            this.reader.removeFields();
        } else {
            this.stamper.setFreeTextFlattening(false);
            this.stamper.setFormFlattening(false);
        }
        this.reader.consolidateNamedDestinations();
        this.reader.eliminateSharedStreams();
        try {
            this.stamper.close();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static void checkDestPath(String path) {
        PdfDocMix.checkString(path, "Caminho destinado a gera\u00e7\u00e3o do(s) arquivo(s) n\u00e3o cont\u00e9m informa\u00e7\u00e3o!");
    }

    private static void checkTemplatePath(String path) {
        PdfDocMix.checkString(path, "Caminho do template n\u00e3o cont\u00e9m informa\u00e7\u00e3o!");
    }

    private static void checkTemplateFile(Object template) {
        Objects.checkNotNull(template, "Arquivo de template nulo!");
    }

    private static void checkString(String str, String msg) {
        Objects.checkNotNull(str);
        Strings.checkNotBlank(str, msg);
    }

    private static void checkDestURL(URL url) {
        Objects.checkNotNull(url, "URL destinada a gera\u00e7\u00e3o do(s) documentos(s) nula!");
    }

    private static void checkDestFile(File file) {
        Objects.checkNotNull(file, "Arquivo destinado a gera\u00e7\u00e3o do(s) documentos(s) nulo!");
    }
}

