/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.pdf;

import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.PdfReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jrimum.bopepo.pdf.PdfDocInfo;
import org.jrimum.utilix.Collections;
import org.jrimum.utilix.Exceptions;

public class PdfDocReader {
    private final PdfReader reader;
    private final AcroFields form;
    private final PdfDocInfo docInfo;

    private PdfDocReader() {
        Exceptions.throwIllegalStateException("Estado n\u00e3o permitido!");
        this.reader = null;
        this.form = null;
        this.docInfo = null;
    }

    public PdfDocReader(byte[] pdfIn) {
        PdfReader r = null;
        try {
            r = new PdfReader(pdfIn);
        }
        catch (Exception e) {
            Exceptions.throwIllegalStateException(e);
        }
        this.reader = r;
        this.form = this.reader.getAcroFields();
        this.docInfo = PdfDocInfo.create(this.reader.getInfo());
    }

    public PdfDocReader(InputStream is) {
        PdfReader r = null;
        try {
            r = new PdfReader(is);
        }
        catch (Exception e) {
            Exceptions.throwIllegalStateException(e);
        }
        this.reader = r;
        this.form = this.reader.getAcroFields();
        this.docInfo = PdfDocInfo.create(this.reader.getInfo());
    }

    public PdfDocReader(URL url) {
        PdfReader r = null;
        try {
            r = new PdfReader(url);
        }
        catch (Exception e) {
            Exceptions.throwIllegalStateException(e);
        }
        this.reader = r;
        this.form = this.reader.getAcroFields();
        this.docInfo = PdfDocInfo.create(this.reader.getInfo());
    }

    public PdfDocReader(File file) {
        PdfReader r = null;
        try {
            r = new PdfReader((InputStream)new FileInputStream(file));
        }
        catch (Exception e) {
            Exceptions.throwIllegalStateException(e);
        }
        this.reader = r;
        this.form = this.reader.getAcroFields();
        this.docInfo = PdfDocInfo.create(this.reader.getInfo());
    }

    public PdfDocReader(byte[] pdfIn, byte[] ownerPassword) {
        PdfReader r = null;
        try {
            r = new PdfReader(pdfIn, ownerPassword);
        }
        catch (Exception e) {
            Exceptions.throwIllegalStateException(e);
        }
        this.reader = r;
        this.form = this.reader.getAcroFields();
        this.docInfo = PdfDocInfo.create(this.reader.getInfo());
    }

    public PdfDocReader(InputStream is, byte[] ownerPassword) {
        PdfReader r = null;
        try {
            r = new PdfReader(is, ownerPassword);
        }
        catch (Exception e) {
            Exceptions.throwIllegalStateException(e);
        }
        this.reader = r;
        this.form = this.reader.getAcroFields();
        this.docInfo = PdfDocInfo.create(this.reader.getInfo());
    }

    public PdfDocReader(URL url, byte[] ownerPassword) {
        PdfReader r = null;
        try {
            r = new PdfReader(url, ownerPassword);
        }
        catch (Exception e) {
            Exceptions.throwIllegalStateException(e);
        }
        this.reader = r;
        this.form = this.reader.getAcroFields();
        this.docInfo = PdfDocInfo.create(this.reader.getInfo());
    }

    public PdfDocReader(File file, byte[] ownerPassword) {
        PdfReader r = null;
        try {
            r = new PdfReader((InputStream)new FileInputStream(file), ownerPassword);
        }
        catch (Exception e) {
            Exceptions.throwIllegalStateException(e);
        }
        this.reader = r;
        this.form = this.reader.getAcroFields();
        this.docInfo = PdfDocInfo.create(this.reader.getInfo());
    }

    public String getField(String name) {
        return this.form.getField(name);
    }

    public Collection<String> getFieldsNames() {
        return this.form.getFields().keySet();
    }

    public Map<String, String> getFields() {
        Collection<String> names = this.getFieldsNames();
        if (Collections.hasElement(names)) {
            HashMap<String, String> fields = new HashMap<String, String>(names.size());
            for (String name : names) {
                fields.put(name, this.getField(name));
            }
            return fields;
        }
        return java.util.Collections.emptyMap();
    }

    public PdfDocInfo getInfo() {
        return this.docInfo;
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (Exception e) {
            Exceptions.throwIllegalStateException(e);
        }
    }
}

