/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.view;

import java.awt.Image;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.jrimum.bopepo.Boleto;
import org.jrimum.bopepo.LinhaDigitavel;
import org.jrimum.bopepo.pdf.CodigoDeBarras;
import org.jrimum.bopepo.view.BoletoInfoCampoAgenciaCodigoCedente;
import org.jrimum.bopepo.view.BoletoInfoCampoCodigoBanco;
import org.jrimum.bopepo.view.BoletoInfoCampoEndereco;
import org.jrimum.bopepo.view.BoletoInfoCampoLogoBanco;
import org.jrimum.bopepo.view.BoletoInfoCampoNossoNumero;
import org.jrimum.bopepo.view.BoletoInfoCampoPessoa;
import org.jrimum.bopepo.view.BoletoInfoCampoView;
import org.jrimum.bopepo.view.ResourceBundle;
import org.jrimum.domkee.banco.TipoDeTitulo;
import org.jrimum.utilix.DateFormat;
import org.jrimum.utilix.DecimalFormat;
import org.jrimum.utilix.Exceptions;
import org.jrimum.utilix.Objects;

public abstract class AbstractBoletoInfoCampoView
implements BoletoInfoCampoView {
    private final ResourceBundle resourceBundle;
    private final Boleto boleto;

    private AbstractBoletoInfoCampoView() {
        Exceptions.throwIllegalStateException("Instancia\u00e7\u00e3o n\u00e3o permitida!");
        this.resourceBundle = null;
        this.boleto = null;
    }

    public AbstractBoletoInfoCampoView(ResourceBundle resourceBundle, Boleto boleto) {
        Objects.checkNotNull(resourceBundle);
        Objects.checkNotNull(boleto);
        this.resourceBundle = resourceBundle;
        this.boleto = boleto;
    }

    @Override
    public String getTextoRsInstrucaoAoSacado() {
        return this.getValue(this.boleto.getInstrucaoAoSacado());
    }

    @Override
    public String getTextoRsCpfCnpj() {
        try {
            return this.boleto.getTitulo().getCedente().getCPRF().getCodigoFormatado();
        }
        catch (Exception e) {
            log.debug((Object)"Fail on cprf sacado, default vaule 'Empty' in use");
            return "";
        }
    }

    @Override
    public String getTextoRsSacado() {
        return this.getTextoFcSacadoL1();
    }

    @Override
    public String getTextoFcSacadoL1() {
        return BoletoInfoCampoPessoa.getTextoNomeCprfDaPessoa(this.boleto.getTitulo().getSacado());
    }

    @Override
    public String getTextoFcSacadoL2() {
        return BoletoInfoCampoEndereco.getTextoEnderecoLinha1(this.boleto.getTitulo().getSacado());
    }

    @Override
    public String getTextoFcSacadoL3() {
        return BoletoInfoCampoEndereco.getTextoEnderecoLinha2(this.boleto.getTitulo().getSacado());
    }

    @Override
    public String getTextoFcSacadorAvalistaL1() {
        return BoletoInfoCampoPessoa.getTextoNomeCprfDaPessoa(this.boleto.getTitulo().getSacadorAvalista());
    }

    @Override
    public String getTextoFcSacadorAvalistaL2() {
        return BoletoInfoCampoEndereco.getTextoEnderecoLinha1(this.boleto.getTitulo().getSacadorAvalista());
    }

    @Override
    public String getTextoFcSacadorAvalistaL3() {
        return BoletoInfoCampoEndereco.getTextoEnderecoLinha2(this.boleto.getTitulo().getSacadorAvalista());
    }

    @Override
    public String getTextoFcDataProcessamento() {
        return this.getValue(this.boleto.getDataDeProcessamento());
    }

    @Override
    public String getTextoFcAceite() {
        return this.getValue(this.boleto.getTitulo().getAceite());
    }

    @Override
    public String getTextoFcEspecieDocumento() {
        String textoFcEspecieDocumento = "";
        TipoDeTitulo tipoTitulo = this.boleto.getTitulo().getTipoDeDocumento();
        if (tipoTitulo != null) {
            textoFcEspecieDocumento = tipoTitulo.getSigla();
        }
        return textoFcEspecieDocumento;
    }

    @Override
    public String getTextoFcDataDocumento() {
        return this.getValue(this.boleto.getTitulo().getDataDoDocumento());
    }

    @Override
    public String getTextoFcLocalPagamento() {
        return this.getValue(this.boleto.getLocalPagamento());
    }

    @Override
    public String getTextoFcCarteira() {
        return (String)Objects.whenNull(this.boleto.getTitulo().getContaBancaria().getCarteira(), "", this.boleto.getTitulo().getContaBancaria().getCarteira().getCodigo().toString());
    }

    @Override
    public String getTextoFcInstrucaoAoCaixa1() {
        return this.getValue(this.boleto.getInstrucao1());
    }

    @Override
    public String getTextoFcInstrucaoAoCaixa2() {
        return this.getValue(this.boleto.getInstrucao2());
    }

    @Override
    public String getTextoFcInstrucaoAoCaixa3() {
        return this.getValue(this.boleto.getInstrucao3());
    }

    @Override
    public String getTextoFcInstrucaoAoCaixa4() {
        return this.getValue(this.boleto.getInstrucao4());
    }

    @Override
    public String getTextoFcInstrucaoAoCaixa5() {
        return this.getValue(this.boleto.getInstrucao5());
    }

    @Override
    public String getTextoFcInstrucaoAoCaixa6() {
        return this.getValue(this.boleto.getInstrucao6());
    }

    @Override
    public String getTextoFcInstrucaoAoCaixa7() {
        return this.getValue(this.boleto.getInstrucao7());
    }

    @Override
    public String getTextoFcInstrucaoAoCaixa8() {
        return this.getValue(this.boleto.getInstrucao8());
    }

    @Override
    public String getTextoRsMoraMulta() {
        return this.getTextoFcMoraMulta();
    }

    @Override
    public String getTextoFcMoraMulta() {
        return this.getValue(this.boleto.getTitulo().getMora());
    }

    @Override
    public String getTextoRsOutroAcrescimo() {
        return this.getTextoFcOutroAcrescimo();
    }

    @Override
    public String getTextoFcOutroAcrescimo() {
        return this.getValue(this.boleto.getTitulo().getAcrecimo());
    }

    @Override
    public String getTextoRsOutraDeducao() {
        return this.getTextoFcOutraDeducao();
    }

    @Override
    public String getTextoFcOutraDeducao() {
        return this.getValue(this.boleto.getTitulo().getDeducao());
    }

    @Override
    public String getTextoRsDescontoAbatimento() {
        return this.getTextoFcDescontoAbatimento();
    }

    @Override
    public String getTextoFcDescontoAbatimento() {
        return this.getValue(this.boleto.getTitulo().getDesconto());
    }

    @Override
    public String getTextoRsValorDocumento() {
        return this.getTextoFcValorDocumento();
    }

    @Override
    public String getTextoFcValorDocumento() {
        return this.getValue(this.boleto.getTitulo().getValor());
    }

    @Override
    public String getTextoRsValorCobrado() {
        return this.getTextoFcValorCobrado();
    }

    @Override
    public String getTextoFcValorCobrado() {
        return this.getValue(this.boleto.getTitulo().getValorCobrado());
    }

    @Override
    public String getTextoRsDataVencimento() {
        return this.getTextoFcDataVencimento();
    }

    @Override
    public String getTextoFcDataVencimento() {
        return this.getValue(this.boleto.getTitulo().getDataDoVencimento());
    }

    @Override
    public String getTextoRsNumeroDocumento() {
        return this.getTextoFcNumeroDocumento();
    }

    @Override
    public String getTextoFcNumeroDocumento() {
        return this.getValue(this.boleto.getTitulo().getNumeroDoDocumento());
    }

    @Override
    public String getTextoRsCedente() {
        return this.getTextoFcCedente();
    }

    @Override
    public String getTextoFcCedente() {
        return this.getValue(this.boleto.getTitulo().getCedente().getNome());
    }

    @Override
    public String getTextoRsEspecie() {
        return this.getTextoFcEspecie();
    }

    @Override
    public String getTextoFcEspecie() {
        return this.getValue(this.boleto.getTitulo().getTipoDeMoeda());
    }

    @Override
    public String getTextoRsCodigoBanco() {
        return this.getTextoFcCodigoBanco();
    }

    @Override
    public String getTextoFcCodigoBanco() {
        return BoletoInfoCampoCodigoBanco.getTextoCodigoDoBanco(this.boleto.getTitulo().getContaBancaria());
    }

    @Override
    public String getTextoRsAgenciaCodigoCedente() {
        return this.getTextoFcAgenciaCodigoCedente();
    }

    @Override
    public String getTextoFcAgenciaCodigoCedente() {
        return BoletoInfoCampoAgenciaCodigoCedente.getTextoAgenciaCodigoCedente(this.boleto.getTitulo().getContaBancaria());
    }

    @Override
    public String getTextoRsNossoNumero() {
        return this.getTextoFcNossoNumero();
    }

    @Override
    public String getTextoFcNossoNumero() {
        return BoletoInfoCampoNossoNumero.getTextoNossoNumero(this.boleto.getTitulo());
    }

    @Override
    public Image getImagemRsLogoBanco() {
        return this.getImagemFcLogoBanco();
    }

    @Override
    public Image getImagemFcLogoBanco() {
        return BoletoInfoCampoLogoBanco.getImagemBanco(this.resourceBundle, this.boleto.getTitulo().getContaBancaria());
    }

    @Override
    public String getTextoRsLogoBanco() {
        return this.getTextoFcLogoBanco();
    }

    @Override
    public String getTextoFcLogoBanco() {
        return this.boleto.getTitulo().getContaBancaria().getBanco().getNome();
    }

    @Override
    public String getTextoRsLinhaDigitavel() {
        return this.getTextoFcLinhaDigitavel();
    }

    @Override
    public String getTextoFcLinhaDigitavel() {
        LinhaDigitavel linhaDigitavel = this.boleto.getLinhaDigitavel();
        return linhaDigitavel.write();
    }

    @Override
    public Image getImagemFcCodigoBarra() {
        return CodigoDeBarras.valueOf(this.boleto.getCodigoDeBarras().write()).toImage();
    }

    protected final Boleto getBoleto() {
        return this.boleto;
    }

    private String getValue(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        return "";
    }

    private String getValue(Date value) {
        if (Objects.isNotNull(value)) {
            return DateFormat.DDMMYYYY_B.format(value);
        }
        return "";
    }

    private String getValue(BigDecimal value) {
        if (Objects.isNotNull(value)) {
            return DecimalFormat.MONEY_DD_BR.format(value);
        }
        return "";
    }

    private <T extends Enum<?>> String getValue(T value) {
        if (Objects.isNotNull(value)) {
            return value.name();
        }
        return "";
    }
}

