/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.view;

import org.apache.commons.lang3.StringUtils;
import org.jrimum.domkee.banco.EntidadeDeCobranca;
import org.jrimum.domkee.pessoa.Endereco;
import org.jrimum.utilix.Objects;

public class BoletoInfoCampoEndereco {
    public static String getTextoEnderecoLinha1(EntidadeDeCobranca pessoa) {
        if (Objects.isNotNull(pessoa)) {
            return BoletoInfoCampoEndereco.getTextoEnderecoLinha1(pessoa.getNextEndereco());
        }
        return "";
    }

    public static String getTextoEnderecoLinha1(Endereco endereco) {
        StringBuilder texto = new StringBuilder("");
        if (Objects.isNotNull(endereco)) {
            boolean temBairro = false;
            boolean temLocalidade = false;
            if (StringUtils.isNotBlank((CharSequence)endereco.getBairro())) {
                temBairro = true;
                texto.append(endereco.getBairro());
            }
            if (StringUtils.isNotBlank((CharSequence)endereco.getLocalidade())) {
                temLocalidade = true;
                if (temBairro) {
                    texto.append(" - ");
                }
                texto.append(endereco.getLocalidade());
            }
            if (Objects.isNotNull((Object)endereco.getUF())) {
                if (temBairro || temLocalidade) {
                    texto.append(" / ");
                }
                texto.append(endereco.getUF().getSigla());
            }
        }
        return texto.toString();
    }

    public static String getTextoEnderecoLinha2(EntidadeDeCobranca pessoa) {
        if (Objects.isNotNull(pessoa)) {
            return BoletoInfoCampoEndereco.getTextoEnderecoLinha2(pessoa.getNextEndereco());
        }
        return "";
    }

    public static String getTextoEnderecoLinha2(Endereco endereco) {
        StringBuilder texto = new StringBuilder("");
        if (Objects.isNotNull(endereco)) {
            if (StringUtils.isNotBlank((CharSequence)endereco.getLogradouro())) {
                texto.append(endereco.getLogradouro());
            }
            if (StringUtils.isNotBlank((CharSequence)endereco.getNumero())) {
                texto.append(", n\u00b0: ").append(endereco.getNumero());
            }
            if (StringUtils.isNotBlank((CharSequence)endereco.getComplemento())) {
                texto.append(" / ").append(endereco.getComplemento());
            }
            if (Objects.isNotNull(endereco.getCEP()) && StringUtils.isNotBlank((CharSequence)endereco.getCEP().getCep())) {
                texto.append(" - ").append("CEP: ").append(endereco.getCEP().getCep());
            }
        }
        return texto.toString();
    }
}

