/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.view;

import org.jrimum.bopepo.BancosSuportados;
import org.jrimum.bopepo.Boleto;
import org.jrimum.bopepo.view.AbstractBoletoInfoViewHSBC;
import org.jrimum.bopepo.view.BoletoInfoCampoView;
import org.jrimum.bopepo.view.BoletoInfoViewBradesco;
import org.jrimum.bopepo.view.BoletoInfoViewCaixaFactory;
import org.jrimum.bopepo.view.BoletoInfoViewCecred;
import org.jrimum.bopepo.view.BoletoInfoViewDefault;
import org.jrimum.bopepo.view.BoletoInfoViewSicredi;
import org.jrimum.bopepo.view.ResourceBundle;
import org.jrimum.utilix.Objects;

public class BoletoInfoCampoViewFactory {
    public static BoletoInfoCampoView create(ResourceBundle resourceBundle, Boleto boleto) {
        BancosSuportados banco = BancosSuportados.suportados.get(boleto.getTitulo().getContaBancaria().getBanco().getCodigoDeCompensacaoBACEN().getCodigoFormatado());
        if (Objects.isNotNull((Object)banco)) {
            switch (banco) {
                case BANCO_BRADESCO: {
                    return new BoletoInfoViewBradesco(resourceBundle, boleto);
                }
                case CAIXA_ECONOMICA_FEDERAL: {
                    return BoletoInfoViewCaixaFactory.create(resourceBundle, boleto);
                }
                case HSBC: {
                    return AbstractBoletoInfoViewHSBC.create(resourceBundle, boleto);
                }
                case BANCO_SICREDI: {
                    return new BoletoInfoViewSicredi(resourceBundle, boleto);
                }
                case CECRED: {
                    return new BoletoInfoViewCecred(resourceBundle, boleto);
                }
            }
        }
        return new BoletoInfoViewDefault(resourceBundle, boleto);
    }
}

