/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.view;

import java.awt.Image;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;
import org.jrimum.bopepo.Boleto;
import org.jrimum.bopepo.view.BoletoCampo;
import org.jrimum.bopepo.view.BoletoInfoCampoView;
import org.jrimum.bopepo.view.BoletoInfoCampoViewFactory;
import org.jrimum.bopepo.view.ResourceBundle;
import org.jrimum.utilix.Collections;
import org.jrimum.utilix.Exceptions;
import org.jrimum.utilix.Objects;

public class BoletoInfoViewBuilder {
    private static Logger log = Logger.getLogger(BoletoInfoViewBuilder.class);
    private final Map<String, String> text;
    private final Map<String, Image> image;
    private final Map<String, String> boletoTextosExtra;
    private final Map<String, Image> boletoImagensExtra;
    private final BoletoInfoCampoView boletoInfoCampo;

    private BoletoInfoViewBuilder() {
        Exceptions.throwIllegalStateException("Instancia\u00e7\u00e3o n\u00e3o permitida!");
        this.text = null;
        this.image = null;
        this.boletoTextosExtra = null;
        this.boletoImagensExtra = null;
        this.boletoInfoCampo = null;
    }

    public BoletoInfoViewBuilder(ResourceBundle resourceBundle, Boleto boleto) {
        Objects.checkNotNull(resourceBundle);
        Objects.checkNotNull(boleto);
        this.text = new WeakHashMap<String, String>();
        this.image = new WeakHashMap<String, Image>();
        this.boletoTextosExtra = boleto.getTextosExtras();
        this.boletoImagensExtra = boleto.getImagensExtras();
        this.boletoInfoCampo = BoletoInfoCampoViewFactory.create(resourceBundle, boleto);
    }

    public Map<String, String> texts() {
        return new WeakHashMap<String, String>(this.text);
    }

    public Map<String, Image> images() {
        return new WeakHashMap<String, Image>(this.image);
    }

    public BoletoInfoViewBuilder build() {
        this.setLogotipoDoBanco();
        this.setCodigoDoBanco();
        this.setLinhaDigitavel();
        this.setCedente();
        this.setAgenciaCodigoCedente();
        this.setEspecie();
        this.setNossoNumero();
        this.setNumeroDocumento();
        this.setCprfCedente();
        this.setDataVencimeto();
        this.setValorDocumento();
        this.setDescontoAbatimento();
        this.setOutraDeducao();
        this.setMoraMulta();
        this.setOutroAcrescimo();
        this.setValorCobrado();
        this.setInstrucaoAoSacado();
        this.setInstrucaoAoCaixa();
        this.setSacado();
        this.setLocalPagamento();
        this.setDataDocumento();
        this.setEspecieDoc();
        this.setAceite();
        this.setDataProcessamento();
        this.setSacadorAvalista();
        this.setCodigoDeBarras();
        this.setCarteira();
        this.setTodosOsCamposTexto();
        this.setTodosOsCamposImagem();
        return this;
    }

    private void setInstrucaoAoSacado() {
        this.text.put(BoletoCampo.txtRsInstrucaoAoSacado.name(), this.boletoInfoCampo.getTextoRsInstrucaoAoSacado());
    }

    private void setCprfCedente() {
        this.text.put(BoletoCampo.txtRsCpfCnpj.name(), this.boletoInfoCampo.getTextoRsCpfCnpj());
    }

    private void setDataProcessamento() {
        this.text.put(BoletoCampo.txtFcDataProcessamento.name(), this.boletoInfoCampo.getTextoFcDataProcessamento());
    }

    private void setLocalPagamento() {
        this.text.put(BoletoCampo.txtFcLocalPagamento.name(), this.boletoInfoCampo.getTextoFcLocalPagamento());
    }

    private void setAceite() {
        this.text.put(BoletoCampo.txtFcAceite.name(), this.boletoInfoCampo.getTextoFcAceite());
    }

    private void setEspecieDoc() {
        this.text.put(BoletoCampo.txtFcEspecieDocumento.name(), this.boletoInfoCampo.getTextoFcEspecieDocumento());
    }

    private void setDataDocumento() {
        this.text.put(BoletoCampo.txtFcDataDocumento.name(), this.boletoInfoCampo.getTextoFcDataDocumento());
    }

    private void setCarteira() {
        this.text.put(BoletoCampo.txtFcCarteira.name(), this.boletoInfoCampo.getTextoFcCarteira());
    }

    private void setSacado() {
        this.text.put(BoletoCampo.txtRsSacado.name(), this.boletoInfoCampo.getTextoRsSacado());
        this.text.put(BoletoCampo.txtFcSacadoL1.name(), this.boletoInfoCampo.getTextoFcSacadoL1());
        this.text.put(BoletoCampo.txtFcSacadoL2.name(), this.boletoInfoCampo.getTextoFcSacadoL2());
        this.text.put(BoletoCampo.txtFcSacadoL3.name(), this.boletoInfoCampo.getTextoFcSacadoL3());
    }

    private void setSacadorAvalista() {
        this.text.put(BoletoCampo.txtFcSacadorAvalistaL1.name(), this.boletoInfoCampo.getTextoFcSacadorAvalistaL1());
        this.text.put(BoletoCampo.txtFcSacadorAvalistaL2.name(), this.boletoInfoCampo.getTextoFcSacadorAvalistaL2());
        this.text.put(BoletoCampo.txtFcSacadorAvalistaL3.name(), this.boletoInfoCampo.getTextoFcSacadorAvalistaL3());
    }

    private void setInstrucaoAoCaixa() {
        this.text.put(BoletoCampo.txtFcInstrucaoAoCaixa1.name(), this.boletoInfoCampo.getTextoFcInstrucaoAoCaixa1());
        this.text.put(BoletoCampo.txtFcInstrucaoAoCaixa2.name(), this.boletoInfoCampo.getTextoFcInstrucaoAoCaixa2());
        this.text.put(BoletoCampo.txtFcInstrucaoAoCaixa3.name(), this.boletoInfoCampo.getTextoFcInstrucaoAoCaixa3());
        this.text.put(BoletoCampo.txtFcInstrucaoAoCaixa4.name(), this.boletoInfoCampo.getTextoFcInstrucaoAoCaixa4());
        this.text.put(BoletoCampo.txtFcInstrucaoAoCaixa5.name(), this.boletoInfoCampo.getTextoFcInstrucaoAoCaixa5());
        this.text.put(BoletoCampo.txtFcInstrucaoAoCaixa6.name(), this.boletoInfoCampo.getTextoFcInstrucaoAoCaixa6());
        this.text.put(BoletoCampo.txtFcInstrucaoAoCaixa7.name(), this.boletoInfoCampo.getTextoFcInstrucaoAoCaixa7());
        this.text.put(BoletoCampo.txtFcInstrucaoAoCaixa8.name(), this.boletoInfoCampo.getTextoFcInstrucaoAoCaixa8());
    }

    private void setMoraMulta() {
        this.text.put(BoletoCampo.txtRsMoraMulta.name(), this.boletoInfoCampo.getTextoRsMoraMulta());
        this.text.put(BoletoCampo.txtFcMoraMulta.name(), this.boletoInfoCampo.getTextoFcMoraMulta());
    }

    private void setOutroAcrescimo() {
        this.text.put(BoletoCampo.txtRsOutroAcrescimo.name(), this.boletoInfoCampo.getTextoRsOutroAcrescimo());
        this.text.put(BoletoCampo.txtFcOutroAcrescimo.name(), this.boletoInfoCampo.getTextoFcOutroAcrescimo());
    }

    private void setOutraDeducao() {
        this.text.put(BoletoCampo.txtRsOutraDeducao.name(), this.boletoInfoCampo.getTextoRsOutraDeducao());
        this.text.put(BoletoCampo.txtFcOutraDeducao.name(), this.boletoInfoCampo.getTextoFcOutraDeducao());
    }

    private void setDescontoAbatimento() {
        this.text.put(BoletoCampo.txtRsDescontoAbatimento.name(), this.boletoInfoCampo.getTextoRsDescontoAbatimento());
        this.text.put(BoletoCampo.txtFcDescontoAbatimento.name(), this.boletoInfoCampo.getTextoFcDescontoAbatimento());
    }

    private void setValorDocumento() {
        this.text.put(BoletoCampo.txtRsValorDocumento.name(), this.boletoInfoCampo.getTextoRsValorDocumento());
        this.text.put(BoletoCampo.txtFcValorDocumento.name(), this.boletoInfoCampo.getTextoFcValorDocumento());
    }

    private void setValorCobrado() {
        this.text.put(BoletoCampo.txtRsValorCobrado.name(), this.boletoInfoCampo.getTextoRsValorCobrado());
        this.text.put(BoletoCampo.txtFcValorCobrado.name(), this.boletoInfoCampo.getTextoFcValorCobrado());
    }

    private void setDataVencimeto() {
        this.text.put(BoletoCampo.txtRsDataVencimento.name(), this.boletoInfoCampo.getTextoRsDataVencimento());
        this.text.put(BoletoCampo.txtFcDataVencimento.name(), this.boletoInfoCampo.getTextoFcDataVencimento());
    }

    private void setNumeroDocumento() {
        this.text.put(BoletoCampo.txtRsNumeroDocumento.name(), this.boletoInfoCampo.getTextoRsNumeroDocumento());
        this.text.put(BoletoCampo.txtFcNumeroDocumento.name(), this.boletoInfoCampo.getTextoFcNumeroDocumento());
    }

    private void setCedente() {
        this.text.put(BoletoCampo.txtRsCedente.name(), this.boletoInfoCampo.getTextoRsCedente());
        this.text.put(BoletoCampo.txtFcCedente.name(), this.boletoInfoCampo.getTextoFcCedente());
    }

    private void setEspecie() {
        this.text.put(BoletoCampo.txtRsEspecie.name(), this.boletoInfoCampo.getTextoRsEspecie());
        this.text.put(BoletoCampo.txtFcEspecie.name(), this.boletoInfoCampo.getTextoFcEspecie());
    }

    private void setCodigoDoBanco() {
        this.text.put(BoletoCampo.txtRsCodBanco.name(), this.boletoInfoCampo.getTextoRsCodigoBanco());
        this.text.put(BoletoCampo.txtFcCodBanco.name(), this.boletoInfoCampo.getTextoFcCodigoBanco());
    }

    private void setAgenciaCodigoCedente() {
        this.text.put(BoletoCampo.txtRsAgenciaCodigoCedente.name(), this.boletoInfoCampo.getTextoRsAgenciaCodigoCedente());
        this.text.put(BoletoCampo.txtFcAgenciaCodigoCedente.name(), this.boletoInfoCampo.getTextoFcAgenciaCodigoCedente());
    }

    private void setNossoNumero() {
        this.text.put(BoletoCampo.txtRsNossoNumero.name(), this.boletoInfoCampo.getTextoRsNossoNumero());
        this.text.put(BoletoCampo.txtFcNossoNumero.name(), this.boletoInfoCampo.getTextoFcNossoNumero());
    }

    private void setLogotipoDoBanco() {
        if (Objects.isNotNull(this.boletoInfoCampo.getImagemFcLogoBanco())) {
            this.image.put(BoletoCampo.txtRsLogoBanco.name(), this.boletoInfoCampo.getImagemRsLogoBanco());
            this.image.put(BoletoCampo.txtFcLogoBanco.name(), this.boletoInfoCampo.getImagemFcLogoBanco());
        } else {
            log.warn((Object)"Banco sem imagem definida. O nome da institui\u00e7\u00e3o ser\u00e1 usado como logo.");
            this.text.put(BoletoCampo.txtRsLogoBanco.name(), this.boletoInfoCampo.getTextoRsLogoBanco());
            this.text.put(BoletoCampo.txtFcLogoBanco.name(), this.boletoInfoCampo.getTextoFcLogoBanco());
        }
    }

    private void setLinhaDigitavel() {
        this.text.put(BoletoCampo.txtRsLinhaDigitavel.name(), this.boletoInfoCampo.getTextoRsLinhaDigitavel());
        this.text.put(BoletoCampo.txtFcLinhaDigitavel.name(), this.boletoInfoCampo.getTextoFcLinhaDigitavel());
    }

    private void setCodigoDeBarras() {
        this.image.put(BoletoCampo.txtFcCodigoBarra.name(), this.boletoInfoCampo.getImagemFcCodigoBarra());
    }

    private void setTodosOsCamposTexto() {
        if (Collections.hasElement(this.boletoTextosExtra)) {
            for (Map.Entry<String, String> entry : this.boletoTextosExtra.entrySet()) {
                this.text.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private void setTodosOsCamposImagem() {
        if (Collections.hasElement(this.boletoImagensExtra)) {
            for (Map.Entry<String, Image> entry : this.boletoImagensExtra.entrySet()) {
                this.image.put(entry.getKey(), entry.getValue());
            }
        }
    }
}

