/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.view;

import org.jrimum.bopepo.Boleto;
import org.jrimum.bopepo.view.BoletoInfoCampoView;
import org.jrimum.bopepo.view.BoletoInfoViewCaixaSICOB10;
import org.jrimum.bopepo.view.BoletoInfoViewCaixaSICOB14;
import org.jrimum.bopepo.view.BoletoInfoViewCaixaSIGCB;
import org.jrimum.bopepo.view.BoletoInfoViewCaixaSINCO;
import org.jrimum.bopepo.view.ResourceBundle;

public class BoletoInfoViewCaixaFactory {
    private static final int NN10 = 10;
    private static final int NN14 = 14;
    private static final int NN15 = 15;
    private static final int NN17 = 17;

    public static BoletoInfoCampoView create(ResourceBundle resourceBundle, Boleto boleto) {
        String nossoNumero = boleto.getTitulo().getNossoNumero();
        switch (nossoNumero.length()) {
            case 10: {
                return new BoletoInfoViewCaixaSICOB10(resourceBundle, boleto);
            }
            case 14: {
                return new BoletoInfoViewCaixaSICOB14(resourceBundle, boleto);
            }
            case 15: {
                return new BoletoInfoViewCaixaSIGCB(resourceBundle, boleto);
            }
            case 17: {
                return new BoletoInfoViewCaixaSINCO(resourceBundle, boleto);
            }
        }
        return null;
    }
}

