/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.view;

import org.apache.commons.lang3.StringUtils;
import org.jrimum.bopepo.Boleto;
import org.jrimum.bopepo.parametro.ParametroCaixaEconomicaFederal;
import org.jrimum.bopepo.view.AbstractBoletoInfoCampoView;
import org.jrimum.bopepo.view.ResourceBundle;
import org.jrimum.domkee.banco.Titulo;
import org.jrimum.utilix.Objects;

public class BoletoInfoViewCaixaSICOB14
extends AbstractBoletoInfoCampoView {
    private static final int CODIGO_OPERACAO_PADRAO = 870;

    public BoletoInfoViewCaixaSICOB14(ResourceBundle resourceBundle, Boleto boleto) {
        super(resourceBundle, boleto);
    }

    @Override
    public String getTextoFcCarteira() {
        return "SR";
    }

    @Override
    public String getTextoFcAgenciaCodigoCedente() {
        Integer agencia = this.getBoleto().getTitulo().getContaBancaria().getAgencia().getCodigo();
        Integer codigoOperacao = this.getCodigoOperacao();
        Integer codigoBeneficiario = this.getBoleto().getTitulo().getContaBancaria().getNumeroDaConta().getCodigoDaConta();
        String digitoDaConta = this.getBoleto().getTitulo().getContaBancaria().getNumeroDaConta().getDigitoDaConta();
        return String.format("%04d.%03d.%08d-%s", agencia, codigoOperacao, codigoBeneficiario, digitoDaConta);
    }

    private Integer getCodigoOperacao() {
        Titulo titulo = this.getBoleto().getTitulo();
        Integer codigoOperacao = 870;
        if (titulo.hasParametrosBancarios() && Objects.isNotNull(titulo.getParametrosBancarios().getValor(ParametroCaixaEconomicaFederal.CODIGO_OPERACAO))) {
            codigoOperacao = (Integer)titulo.getParametrosBancarios().getValor(ParametroCaixaEconomicaFederal.CODIGO_OPERACAO);
        }
        return codigoOperacao;
    }

    @Override
    public String getTextoFcLocalPagamento() {
        String textoFcLocalPagamento = super.getTextoFcLocalPagamento();
        return StringUtils.isBlank((CharSequence)textoFcLocalPagamento) ? "PREFERENCIALMENTE NAS CASAS LOT\u00c9RICAS AT\u00c9 O VALOR LIMITE" : textoFcLocalPagamento;
    }
}

