/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.view;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jrimum.bopepo.Boleto;
import org.jrimum.bopepo.pdf.Files;
import org.jrimum.bopepo.view.PdfViewer;
import org.jrimum.bopepo.view.PdfViewerMultiProcessor;
import org.jrimum.utilix.Collections;
import org.jrimum.utilix.Exceptions;
import org.jrimum.utilix.Objects;
import org.jrimum.utilix.Strings;

public class BoletoViewer {
    private static Logger log = Logger.getLogger(BoletoViewer.class);
    private PdfViewer pdfViewer;

    public BoletoViewer(Boleto boleto) {
        BoletoViewer.checkBoleto(boleto);
        this.pdfViewer = new PdfViewer(boleto);
    }

    public BoletoViewer(Boleto boleto, String templatePath) {
        BoletoViewer.checkBoleto(boleto);
        BoletoViewer.checkTemplatePath(templatePath);
        this.pdfViewer = new PdfViewer(boleto);
        this.setTemplate(templatePath);
    }

    public BoletoViewer(Boleto boleto, File templateFile) {
        BoletoViewer.checkBoleto(boleto);
        BoletoViewer.checkTemplateFile(templateFile);
        this.pdfViewer = new PdfViewer(boleto);
        this.setTemplate(templateFile);
    }

    public BoletoViewer(Boleto boleto, URL templateUrl) {
        BoletoViewer.checkBoleto(boleto);
        BoletoViewer.checkTemplateFile(templateUrl);
        this.pdfViewer = new PdfViewer(boleto);
        this.setTemplate(templateUrl);
    }

    public BoletoViewer(Boleto boleto, InputStream templateInput) {
        BoletoViewer.checkBoleto(boleto);
        BoletoViewer.checkTemplateFile(templateInput);
        this.pdfViewer = new PdfViewer(boleto);
        this.setTemplate(templateInput);
    }

    public BoletoViewer(Boleto boleto, byte[] template) {
        BoletoViewer.checkBoleto(boleto);
        BoletoViewer.checkTemplateFile(template);
        this.pdfViewer = new PdfViewer(boleto);
        this.setTemplate(template);
    }

    protected BoletoViewer() {
        this.pdfViewer = new PdfViewer();
    }

    protected BoletoViewer(PdfViewer pdfViewer) {
        this.pdfViewer = pdfViewer;
    }

    public static BoletoViewer create(Boleto boleto) {
        BoletoViewer.checkBoleto(boleto);
        return new BoletoViewer(boleto);
    }

    public static byte[] groupInOnePDF(List<Boleto> boletos) {
        BoletoViewer.checkBoletosList(boletos);
        return PdfViewerMultiProcessor.groupInOnePDF(boletos, new BoletoViewer());
    }

    public static File groupInOnePDF(List<Boleto> boletos, String destPath) {
        BoletoViewer.checkBoletosList(boletos);
        BoletoViewer.checkDestPath(destPath);
        return PdfViewerMultiProcessor.groupInOnePDF(boletos, new BoletoViewer(), new File(destPath));
    }

    public static File groupInOnePDF(List<Boleto> boletos, File destFile) {
        BoletoViewer.checkBoletosList(boletos);
        BoletoViewer.checkDestFile(destFile);
        return PdfViewerMultiProcessor.groupInOnePDF(boletos, new BoletoViewer(), destFile);
    }

    public static byte[] groupInOnePdfWithTemplate(List<Boleto> boletos, String templatePath) {
        BoletoViewer.checkBoletosList(boletos);
        BoletoViewer.checkTemplatePath(templatePath);
        return PdfViewerMultiProcessor.groupInOnePDF(boletos, new BoletoViewer().setTemplate(templatePath));
    }

    public static byte[] groupInOnePdfWithTemplate(List<Boleto> boletos, URL templateUrl) {
        BoletoViewer.checkBoletosList(boletos);
        BoletoViewer.checkTemplateFile(templateUrl);
        return PdfViewerMultiProcessor.groupInOnePDF(boletos, new BoletoViewer().setTemplate(templateUrl));
    }

    public static byte[] groupInOnePdfWithTemplate(List<Boleto> boletos, File templateFile) {
        BoletoViewer.checkBoletosList(boletos);
        BoletoViewer.checkTemplateFile(templateFile);
        return PdfViewerMultiProcessor.groupInOnePDF(boletos, new BoletoViewer().setTemplate(templateFile));
    }

    public static byte[] groupInOnePdfWithTemplate(List<Boleto> boletos, InputStream templateInput) {
        BoletoViewer.checkBoletosList(boletos);
        BoletoViewer.checkTemplateFile(templateInput);
        return PdfViewerMultiProcessor.groupInOnePDF(boletos, new BoletoViewer().setTemplate(templateInput));
    }

    public static byte[] groupInOnePdfWithTemplate(List<Boleto> boletos, byte[] template) {
        BoletoViewer.checkBoletosList(boletos);
        BoletoViewer.checkTemplateFile(template);
        return PdfViewerMultiProcessor.groupInOnePDF(boletos, new BoletoViewer().setTemplate(template));
    }

    public static File groupInOnePdfWithTemplate(List<Boleto> boletos, String destPath, String templatePath) {
        BoletoViewer.checkBoletosList(boletos);
        BoletoViewer.checkDestPath(destPath);
        BoletoViewer.checkTemplatePath(templatePath);
        return PdfViewerMultiProcessor.groupInOnePDF(boletos, new BoletoViewer().setTemplate(templatePath), new File(destPath));
    }

    public static File groupInOnePdfWithTemplate(List<Boleto> boletos, String destPath, File templateFile) {
        BoletoViewer.checkBoletosList(boletos);
        BoletoViewer.checkDestPath(destPath);
        BoletoViewer.checkTemplateFile(templateFile);
        return PdfViewerMultiProcessor.groupInOnePDF(boletos, new BoletoViewer().setTemplate(templateFile), new File(destPath));
    }

    public static File groupInOnePdfWithTemplate(List<Boleto> boletos, File destFile, String templatePath) {
        BoletoViewer.checkBoletosList(boletos);
        BoletoViewer.checkDestFile(destFile);
        BoletoViewer.checkTemplatePath(templatePath);
        return PdfViewerMultiProcessor.groupInOnePDF(boletos, new BoletoViewer().setTemplate(templatePath), destFile);
    }

    public static File groupInOnePdfWithTemplate(List<Boleto> boletos, File destFile, File templateFile) {
        BoletoViewer.checkBoletosList(boletos);
        BoletoViewer.checkDestFile(destFile);
        BoletoViewer.checkTemplateFile(templateFile);
        return PdfViewerMultiProcessor.groupInOnePDF(boletos, new BoletoViewer().setTemplate(templateFile), destFile);
    }

    public static byte[] groupInOnePdfWithTemplates(Collection<Map.Entry<byte[], List<Boleto>>> templatesAndBoletos) {
        BoletoViewer.checkTemplateBoletosEntries(templatesAndBoletos);
        return PdfViewerMultiProcessor.groupInOnePDF(templatesAndBoletos);
    }

    public static File groupInOnePdfWithTemplates(Collection<Map.Entry<byte[], List<Boleto>>> templatesAndBoletos, File destFile) {
        BoletoViewer.checkTemplateBoletosEntries(templatesAndBoletos);
        BoletoViewer.checkDestFile(destFile);
        try {
            return Files.bytesToFile(destFile, PdfViewerMultiProcessor.groupInOnePDF(templatesAndBoletos));
        }
        catch (Exception e) {
            return (File)Exceptions.throwIllegalStateException("Erro inesperado!", e);
        }
    }

    public static byte[] groupInOnePdfWithTemplates(Map<byte[], List<Boleto>> templatesAndBoletos) {
        BoletoViewer.checkTemplateBoletosEntries(templatesAndBoletos);
        return BoletoViewer.groupInOnePdfWithTemplates(templatesAndBoletos.entrySet());
    }

    public static File groupInOnePdfWithTemplates(Map<byte[], List<Boleto>> templatesAndBoletos, File destFile) {
        BoletoViewer.checkTemplateBoletosEntries(templatesAndBoletos);
        BoletoViewer.checkDestFile(destFile);
        return BoletoViewer.groupInOnePdfWithTemplates(templatesAndBoletos.entrySet(), destFile);
    }

    public static List<byte[]> onePerPDF(List<Boleto> boletos) {
        BoletoViewer.checkBoletosList(boletos);
        return PdfViewerMultiProcessor.onePerPDF(boletos);
    }

    public static List<File> onePerPDF(List<Boleto> boletos, String destPath) {
        BoletoViewer.checkBoletosList(boletos);
        BoletoViewer.checkDestPath(destPath);
        return BoletoViewer.onePerPDF(boletos, new File(destPath), "", "");
    }

    public static List<File> onePerPDF(List<Boleto> boletos, File destDir) {
        BoletoViewer.checkBoletosList(boletos);
        BoletoViewer.checkDestDir(destDir);
        return BoletoViewer.onePerPDF(boletos, destDir, "", "");
    }

    public static List<File> onePerPDF(List<Boleto> boletos, String destPath, String prefixo) {
        BoletoViewer.checkBoletosList(boletos);
        BoletoViewer.checkDestPath(destPath);
        return BoletoViewer.onePerPDF(boletos, new File(destPath), prefixo, "");
    }

    public static List<File> onePerPDF(List<Boleto> boletos, File destDir, String prefixo) {
        BoletoViewer.checkBoletosList(boletos);
        BoletoViewer.checkDestDir(destDir);
        return BoletoViewer.onePerPDF(boletos, destDir, prefixo, "");
    }

    public static List<File> onePerPDF(List<Boleto> boletos, String destPath, String prefixo, String sufixo) {
        BoletoViewer.checkBoletosList(boletos);
        BoletoViewer.checkDestPath(destPath);
        return BoletoViewer.onePerPDF(boletos, new File(destPath), prefixo, sufixo);
    }

    public static List<File> onePerPDF(List<Boleto> boletos, File destDir, String prefixo, String sufixo) {
        BoletoViewer.checkBoletosList(boletos);
        BoletoViewer.checkDestDir(destDir);
        ArrayList<File> files = new ArrayList<File>(boletos.size());
        files.addAll(PdfViewerMultiProcessor.onePerPDF(boletos, destDir, prefixo, sufixo));
        return files;
    }

    public static List<byte[]> onePerPDFWithTemplate(List<Boleto> boletos, String templatePath) {
        BoletoViewer.checkBoletosList(boletos);
        BoletoViewer.checkTemplatePath(templatePath);
        return PdfViewerMultiProcessor.onePerPDF(boletos, new BoletoViewer().setTemplate(templatePath));
    }

    public static List<byte[]> onePerPDFWithTemplate(List<Boleto> boletos, URL templateUrl) {
        BoletoViewer.checkBoletosList(boletos);
        BoletoViewer.checkTemplateFile(templateUrl);
        return PdfViewerMultiProcessor.onePerPDF(boletos, new BoletoViewer().setTemplate(templateUrl));
    }

    public static List<byte[]> onePerPDFWithTemplate(List<Boleto> boletos, File templateFile) {
        BoletoViewer.checkBoletosList(boletos);
        BoletoViewer.checkTemplateFile(templateFile);
        return PdfViewerMultiProcessor.onePerPDF(boletos, new BoletoViewer().setTemplate(templateFile));
    }

    public static List<byte[]> onePerPDFWithTemplate(List<Boleto> boletos, InputStream templateInput) {
        BoletoViewer.checkBoletosList(boletos);
        BoletoViewer.checkTemplateFile(templateInput);
        return PdfViewerMultiProcessor.onePerPDF(boletos, new BoletoViewer().setTemplate(templateInput));
    }

    public static List<byte[]> onePerPDFWithTemplate(List<Boleto> boletos, byte[] template) {
        BoletoViewer.checkBoletosList(boletos);
        BoletoViewer.checkTemplateFile(template);
        return PdfViewerMultiProcessor.onePerPDF(boletos, new BoletoViewer().setTemplate(template));
    }

    public static List<byte[]> onePerPdfWithTemplates(Collection<Map.Entry<byte[], List<Boleto>>> templatesAndBoletos) {
        BoletoViewer.checkTemplateBoletosEntries(templatesAndBoletos);
        return PdfViewerMultiProcessor.onePerPDF(templatesAndBoletos);
    }

    public BoletoViewer setPdfFullCompression(boolean option) {
        this.pdfViewer.setFullCompression(option);
        return this;
    }

    public BoletoViewer setPdfTitulo(String titulo) {
        this.pdfViewer.setTitle(titulo);
        return this;
    }

    public BoletoViewer setPdfExibirTitulo(boolean opcao) {
        this.pdfViewer.setDisplayTitle(opcao);
        return this;
    }

    public BoletoViewer setPdfAutor(String autor) {
        this.pdfViewer.setAuthor(autor);
        return this;
    }

    public BoletoViewer setPdfAssunto(String assunto) {
        this.pdfViewer.setSubject(assunto);
        return this;
    }

    public BoletoViewer setPdfPalavrasChave(String palavrasChave) {
        this.pdfViewer.setKeywords(palavrasChave);
        return this;
    }

    public BoletoViewer setPdfRemoverCampos(boolean opcao) {
        this.pdfViewer.setRemoveFields(opcao);
        return this;
    }

    public BoletoViewer setTemplate(byte[] template) {
        BoletoViewer.checkTemplateFile(template);
        this.pdfViewer.setTemplate(template);
        return this;
    }

    public BoletoViewer setTemplate(URL templateUrl) {
        BoletoViewer.checkTemplateFile(templateUrl);
        this.pdfViewer.setTemplate(templateUrl);
        return this;
    }

    public BoletoViewer setTemplate(InputStream templateInput) {
        BoletoViewer.checkTemplateFile(templateInput);
        this.pdfViewer.setTemplate(templateInput);
        return this;
    }

    public BoletoViewer setTemplate(String templatePath) {
        BoletoViewer.checkTemplatePath(templatePath);
        this.pdfViewer.setTemplate(templatePath);
        return this;
    }

    public BoletoViewer setTemplate(File templateFile) {
        BoletoViewer.checkTemplateFile(templateFile);
        this.pdfViewer.setTemplate(templateFile);
        return this;
    }

    public BoletoViewer setBoleto(Boleto boleto) {
        BoletoViewer.checkBoleto(boleto);
        this.updateViewerPDF(boleto);
        return this;
    }

    public BoletoViewer removeTemplate() {
        String DEFAULT = null;
        if (Objects.isNotNull(this.pdfViewer)) {
            this.pdfViewer.setTemplate(DEFAULT);
        }
        return this;
    }

    public byte[] getTemplate() {
        return this.pdfViewer.getTemplate();
    }

    public Boleto getBoleto() {
        return this.pdfViewer.getBoleto();
    }

    public File getPdfAsFile(String destPath) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("documento instance : " + this.pdfViewer));
        }
        return this.pdfViewer.getFile(destPath);
    }

    public File getPdfAsFile(File destFile) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("documento instance : " + this.pdfViewer));
        }
        return this.pdfViewer.getFile(destFile);
    }

    public ByteArrayOutputStream getPdfAsStream() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("documento instance : " + this.pdfViewer));
        }
        return this.pdfViewer.getStream();
    }

    public byte[] getPdfAsByteArray() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("documento instance : " + this.pdfViewer));
        }
        return this.pdfViewer.getBytes();
    }

    private void updateViewerPDF(Boleto boleto) {
        if (Objects.isNotNull(this.pdfViewer)) {
            this.pdfViewer.setBoleto(boleto);
        } else {
            this.pdfViewer = new PdfViewer(boleto);
        }
    }

    private static void checkDestPath(String path) {
        BoletoViewer.checkString(path, "Caminho destinado a gera\u00e7\u00e3o do(s) arquivo(s) n\u00e3o cont\u00e9m informa\u00e7\u00e3o!");
    }

    private static void checkTemplatePath(String path) {
        BoletoViewer.checkString(path, "Caminho do template n\u00e3o cont\u00e9m informa\u00e7\u00e3o!");
    }

    private static void checkTemplateFile(Object template) {
        Objects.checkNotNull(template, "Arquivo de template nulo!");
    }

    private static void checkString(String str, String msg) {
        Objects.checkNotNull(str);
        Strings.checkNotBlank(str, msg);
    }

    private static void checkDestDir(File file) {
        Objects.checkNotNull(file, "Diret\u00f3rio destinado a gera\u00e7\u00e3o do(s) boleto(s) nulo!");
        Objects.checkArgument(file.isDirectory(), "Isto n\u00e3o \u00e9 um diret\u00f3rio v\u00e1lido!");
    }

    private static void checkDestFile(File file) {
        Objects.checkNotNull(file, "Arquivo destinado a gera\u00e7\u00e3o do(s) boleto(s) nulo!");
    }

    private static void checkBoleto(Boleto boleto) {
        Objects.checkNotNull(boleto, "Boleto nulo!");
    }

    private static void checkBoletosList(List<Boleto> boletos) {
        Objects.checkNotNull(boletos, "Lista de boletos nula!");
        Collections.checkNotEmpty(boletos, "A Lista de boletos est\u00e1 vazia!");
    }

    private static void checkTemplateBoletosEntries(Collection<Map.Entry<byte[], List<Boleto>>> templatesAndBoletos) {
        Collections.checkNotEmpty(templatesAndBoletos, "A Cole\u00e7\u00e3o de pares: (template,boletos) est\u00e1 vazia!");
    }

    private static void checkTemplateBoletosEntries(Map<byte[], List<Boleto>> templatesAndBoletos) {
        Collections.checkNotEmpty(templatesAndBoletos, "O Mapa (template,boletos) est\u00e1 vazio!");
    }
}

