/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.view;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jrimum.bopepo.Guia;
import org.jrimum.bopepo.view.ViewerPDF;
import org.jrimum.utilix.Objects;

public class GuiaViewer {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(GuiaViewer.class);
    private ViewerPDF viewerPDF;

    public GuiaViewer(Guia guia) throws RuntimeException {
        this.initViewerPDF(null, null, guia);
    }

    public GuiaViewer(Guia guia, String templatePathName) throws RuntimeException {
        this.initViewerPDF(templatePathName, null, guia);
    }

    public GuiaViewer(Guia guia, File template) throws RuntimeException {
        this.initViewerPDF(null, template, guia);
    }

    protected GuiaViewer() {
        this.viewerPDF = new ViewerPDF();
    }

    public static File groupInOnePDF(String pathName, List<Guia> guias) throws RuntimeException {
        File group = null;
        if (GuiaViewer.validatePathName(pathName) && GuiaViewer.validateGuiasList(guias)) {
            group = GuiaViewer.groupInOnePDF(pathName, guias, new GuiaViewer());
        }
        return group;
    }

    public static File groupInOnePDF(String destPathName, List<Guia> guias, String templatePathName) throws RuntimeException {
        File group = null;
        if (GuiaViewer.validatePathName(destPathName) && GuiaViewer.validateGuiasList(guias) && GuiaViewer.validatePathName(templatePathName)) {
            group = GuiaViewer.groupInOnePDF(destPathName, guias, new GuiaViewer().setTemplate(templatePathName));
        }
        return group;
    }

    public static File groupInOnePDF(String destPathName, List<Guia> guias, File templateFile) throws RuntimeException {
        File group = null;
        if (GuiaViewer.validatePathName(destPathName) && GuiaViewer.validateGuiasList(guias) && GuiaViewer.validateFile(templateFile, "template")) {
            group = GuiaViewer.groupInOnePDF(destPathName, guias, new GuiaViewer().setTemplate(templateFile));
        }
        return group;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<File> onePerPDF(String path, String extensao, List<Guia> guias) throws RuntimeException {
        ArrayList<File> files = new ArrayList<File>();
        if (!Objects.isNotNull(path) || !Objects.isNotNull(guias)) return files;
        if (!StringUtils.isNotBlank((CharSequence)path)) throw new IllegalArgumentException("Path(Diret\u00f3rio) destinado a gera\u00e7\u00e3o dos arquivos n\u00e3o cont\u00e9m informa\u00e7\u00e3o!");
        if (guias.isEmpty()) throw new IllegalArgumentException("A Lista de guias est\u00e1 vazia!");
        files.addAll(ViewerPDF.onePerPDF(path, extensao, guias));
        return files;
    }

    public File getTemplate() {
        return this.viewerPDF.getTemplate();
    }

    public GuiaViewer setTemplate(File template) {
        if (!Objects.isNotNull(template)) {
            throw new NullPointerException("Arquivo de template inv\u00e1lido: valor [null]");
        }
        this.viewerPDF.setTemplate(template);
        return this;
    }

    public GuiaViewer setTemplate(String pathName) {
        if (!StringUtils.isNotBlank((CharSequence)pathName)) {
            throw new IllegalArgumentException("Caminho do template inv\u00e1lido: valor [" + pathName + "]");
        }
        this.viewerPDF.setTemplate(pathName);
        return this;
    }

    public GuiaViewer removeTemplate() {
        String PADRAO = null;
        if (Objects.isNotNull(this.viewerPDF)) {
            this.viewerPDF.setTemplate(PADRAO);
        }
        return this;
    }

    public File getPdfAsFile(String pathName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Documento instance: " + this.viewerPDF));
        }
        return this.viewerPDF.getFile(pathName);
    }

    public ByteArrayOutputStream getPdfAsStream() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("documento instance : " + this.viewerPDF));
        }
        return this.viewerPDF.getStream();
    }

    public byte[] getPdfAsByteArray() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("documento instance : " + this.viewerPDF));
        }
        return this.viewerPDF.getBytes();
    }

    public Guia getGuia() {
        return this.viewerPDF.getGuia();
    }

    public GuiaViewer setGuia(Guia guia) {
        if (Objects.isNotNull(guia)) {
            this.updateViewerPDF(guia);
        }
        return this;
    }

    private static boolean validatePathName(String pathName) {
        boolean ok = false;
        if (Objects.isNotNull(pathName)) {
            if (StringUtils.isNotBlank((CharSequence)pathName)) {
                ok = true;
            } else {
                throw new IllegalArgumentException("Path(Diret\u00f3rio) destinado a gera\u00e7\u00e3o do(s) arquivo(s) n\u00e3o cont\u00e9m informa\u00e7\u00e3o!");
            }
        }
        return ok;
    }

    private static boolean validateFile(File file, String name) {
        boolean ok = false;
        if (!Objects.isNotNull(file)) {
            throw new NullPointerException("File(Arquivo) destinado a gera\u00e7\u00e3o do(s) documento(s) [" + name + "] nulo!");
        }
        ok = true;
        return ok;
    }

    private static boolean validateGuiasList(List<Guia> guias) {
        boolean ok = false;
        if (Objects.isNotNull(guias)) {
            if (!guias.isEmpty()) {
                ok = true;
            } else {
                throw new IllegalArgumentException("A Lista de guias est\u00e1 vazia!");
            }
        }
        return ok;
    }

    private static File groupInOnePDF(String pathName, List<Guia> guias, GuiaViewer guiaViewer) {
        return ViewerPDF.groupInOnePDF(pathName, guias, guiaViewer);
    }

    private void initViewerPDF(String templatePathName, File template, Guia guia) {
        if (Objects.isNotNull(guia)) {
            this.viewerPDF = new ViewerPDF(guia);
        }
        if (StringUtils.isNotBlank((CharSequence)templatePathName) && Objects.isNotNull(template)) {
            this.setTemplate(template);
        } else {
            if (StringUtils.isNotBlank((CharSequence)templatePathName)) {
                this.setTemplate(templatePathName);
            }
            if (Objects.isNotNull(template)) {
                this.setTemplate(template);
            }
        }
    }

    private void updateViewerPDF(Guia guia) {
        this.viewerPDF = Objects.isNotNull(this.viewerPDF) ? new ViewerPDF(guia, this.viewerPDF.getTemplate()) : new ViewerPDF(guia);
    }
}

