/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.view;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.jrimum.bopepo.Boleto;
import org.jrimum.bopepo.pdf.Files;
import org.jrimum.bopepo.pdf.PdfDocMix;
import org.jrimum.bopepo.view.BoletoInfoViewBuilder;
import org.jrimum.bopepo.view.ResourceBundle;
import org.jrimum.utilix.Exceptions;
import org.jrimum.utilix.Objects;

class PdfViewer {
    private static Logger log = Logger.getLogger(PdfViewer.class);
    private final ResourceBundle resourceBundle = new ResourceBundle();
    private PdfDocMix doc = PdfDocMix.create();
    private Boleto boleto;
    private byte[] template;

    protected PdfViewer() {
    }

    protected PdfViewer(Boleto boleto) {
        this();
        this.boleto = boleto;
    }

    protected PdfViewer(Boleto boleto, byte[] template) {
        this(boleto);
        this.setTemplate(template);
    }

    protected File getFile(String destPath) {
        return this.getFile(new File(destPath));
    }

    protected File getFile(File destFile) {
        try {
            this.processarPdf();
            return this.doc.toFile(destFile);
        }
        catch (Exception e) {
            log.error((Object)("Erro durante a cria\u00e7\u00e3o do arquivo! " + e.getLocalizedMessage()), (Throwable)e);
            return (File)Exceptions.throwIllegalStateException("Erro ao tentar criar arquivo! Causado por " + e.getLocalizedMessage(), e);
        }
    }

    protected ByteArrayOutputStream getStream() {
        try {
            this.processarPdf();
            return this.doc.toStream();
        }
        catch (Exception e) {
            log.error((Object)("Erro durante a cria\u00e7\u00e3o do stream! " + e.getLocalizedMessage()), (Throwable)e);
            return (ByteArrayOutputStream)Exceptions.throwIllegalStateException("Erro durante a cria\u00e7\u00e3o do stream! Causado por " + e.getLocalizedMessage(), e);
        }
    }

    protected byte[] getBytes() {
        try {
            this.processarPdf();
            return this.doc.toBytes();
        }
        catch (Exception e) {
            log.error((Object)("Erro durante a cria\u00e7\u00e3o do array de bytes! " + e.getLocalizedMessage()), (Throwable)e);
            return (byte[])Exceptions.throwIllegalStateException("Erro durante a cria\u00e7\u00e3o do array de bytes! Causado por " + e.getLocalizedMessage(), e);
        }
    }

    protected byte[] getTemplate() {
        return this.template;
    }

    protected void setTemplate(byte[] template) {
        this.template = template;
    }

    protected void setTemplate(URL templateUrl) {
        try {
            this.setTemplate(templateUrl.openStream());
        }
        catch (IOException e) {
            Exceptions.throwIllegalStateException(e);
        }
    }

    protected void setTemplate(InputStream templateInput) {
        try {
            this.setTemplate(Files.toByteArray(templateInput));
        }
        catch (IOException e) {
            Exceptions.throwIllegalStateException(e);
        }
    }

    protected void setTemplate(String templatePath) {
        this.setTemplate(new File(templatePath));
    }

    protected void setTemplate(File templateFile) {
        try {
            this.setTemplate(Files.fileToBytes(templateFile));
        }
        catch (IOException e) {
            Exceptions.throwIllegalStateException(e);
        }
    }

    protected void setFullCompression(boolean option) {
        this.doc.withFullCompression(option);
    }

    protected void setTitle(String title) {
        this.doc.withTitle(title);
    }

    protected void setDisplayTitle(boolean option) {
        this.doc.withDisplayDocTilteOption(option);
    }

    protected void setAuthor(String author) {
        this.doc.withAuthor(author);
    }

    protected void setSubject(String subject) {
        this.doc.withSubject(subject);
    }

    protected void setKeywords(String keywords) {
        this.doc.withKeywords(keywords);
    }

    protected void setRemoveFields(boolean option) {
        this.doc.removeFields(option);
    }

    protected Boleto getBoleto() {
        return this.boleto;
    }

    protected void setBoleto(Boleto boleto) {
        this.boleto = boleto;
    }

    private void processarPdf() {
        byte[] template = null;
        template = this.isTemplateFromResource() ? this.getTemplateFromResource() : this.getTemplate();
        this.doc.withTemplate(template);
        BoletoInfoViewBuilder builder = new BoletoInfoViewBuilder(this.resourceBundle, this.boleto).build();
        this.doc.putAllTexts(builder.texts());
        this.doc.putAllImages(builder.images());
    }

    private byte[] getTemplateFromResource() {
        if (this.boleto.getTitulo().hasSacadorAvalista()) {
            return this.resourceBundle.getTemplateComSacadorAvalista();
        }
        return this.resourceBundle.getTemplateSemSacadorAvalista();
    }

    private boolean isTemplateFromResource() {
        return Objects.isNull(this.getTemplate());
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder((Object)this);
        tsb.append((Object)this.boleto);
        return tsb.toString();
    }
}

