/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.view;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jrimum.bopepo.Boleto;
import org.jrimum.bopepo.pdf.Files;
import org.jrimum.bopepo.pdf.PDFs;
import org.jrimum.bopepo.view.BoletoViewer;
import org.jrimum.utilix.Exceptions;

class PdfViewerMultiProcessor {
    PdfViewerMultiProcessor() {
    }

    protected static byte[] groupInOnePDF(List<Boleto> boletos, BoletoViewer boletoViewer) {
        byte[] file = null;
        ArrayList<byte[]> boletosEmBytes = new ArrayList<byte[]>(boletos.size());
        for (Boleto bop : boletos) {
            boletosEmBytes.add(boletoViewer.setBoleto(bop).getPdfAsByteArray());
        }
        try {
            file = PDFs.mergeFiles(boletosEmBytes);
            boletosEmBytes.clear();
            return file;
        }
        catch (Exception e) {
            return (byte[])Exceptions.throwIllegalStateException("Erro durante gera\u00e7\u00e3o do PDF! Causado por " + e.getLocalizedMessage(), e);
        }
    }

    protected static File groupInOnePDF(List<Boleto> boletos, BoletoViewer boletoViewer, File fileDest) {
        try {
            return Files.bytesToFile(fileDest, PdfViewerMultiProcessor.groupInOnePDF(boletos, boletoViewer));
        }
        catch (Exception e) {
            return (File)Exceptions.throwIllegalStateException("Erro durante gera\u00e7\u00e3o do PDF! Causado por " + e.getLocalizedMessage(), e);
        }
    }

    protected static byte[] groupInOnePDF(Collection<Map.Entry<byte[], List<Boleto>>> templatesAndBoletos) {
        byte[] file = null;
        ArrayList<byte[]> toMerge = new ArrayList<byte[]>(templatesAndBoletos.size());
        BoletoViewer viewer = new BoletoViewer();
        for (Map.Entry<byte[], List<Boleto>> entry : templatesAndBoletos) {
            toMerge.add(PdfViewerMultiProcessor.groupInOnePDF(entry.getValue(), viewer.setTemplate(entry.getKey())));
        }
        file = PDFs.mergeFiles(toMerge);
        toMerge.clear();
        return file;
    }

    protected static List<File> onePerPDF(List<Boleto> boletos, File destDir, String prefixo, String sufixo) {
        ArrayList<File> arquivos = new ArrayList<File>(boletos.size());
        BoletoViewer bv = new BoletoViewer();
        int cont = 1;
        for (Boleto bop : boletos) {
            arquivos.add(bv.setBoleto(bop).getPdfAsFile(destDir.getAbsolutePath() + File.separator + prefixo + cont++ + sufixo + ".pdf"));
        }
        return arquivos;
    }

    protected static List<byte[]> onePerPDF(List<Boleto> boletos) {
        return PdfViewerMultiProcessor.onePerPDF(boletos, new BoletoViewer());
    }

    protected static List<byte[]> onePerPDF(List<Boleto> boletos, BoletoViewer boletoViewer) {
        ArrayList<byte[]> arquivos = new ArrayList<byte[]>(boletos.size());
        for (Boleto bop : boletos) {
            arquivos.add(boletoViewer.setBoleto(bop).getPdfAsByteArray());
        }
        return arquivos;
    }

    protected static List<byte[]> onePerPDF(Collection<Map.Entry<byte[], List<Boleto>>> templatesAndBoletos) {
        ArrayList<byte[]> boletos = new ArrayList<byte[]>(templatesAndBoletos.size());
        BoletoViewer viewer = new BoletoViewer();
        for (Map.Entry<byte[], List<Boleto>> entry : templatesAndBoletos) {
            boletos.addAll(PdfViewerMultiProcessor.onePerPDF(entry.getValue(), viewer.setTemplate(entry.getKey())));
        }
        return boletos;
    }
}

