/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.view;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import org.jrimum.bopepo.pdf.Files;
import org.jrimum.utilix.ClassLoaders;
import org.jrimum.utilix.Exceptions;
import org.jrimum.utilix.Objects;
import org.jrimum.utilix.Strings;

public class ResourceBundle {
    public static final String BOLETO_TEMPLATE_COM_SACADOR_AVALISTA = "BoletoTemplateComSacadorAvalista.pdf";
    public static final String BOLETO_TEMPLATE_SEM_SACADOR_AVALISTA = "BoletoTemplateSemSacadorAvalista.pdf";
    private final Map<String, Image> imagensLogoBanco = new TreeMap<String, Image>();
    private byte[] defaultTemplateComSacadorAvalista;
    private byte[] defaultTemplateSemSacadorAvalista;

    public byte[] getTemplateComSacadorAvalista() {
        if (Objects.isNull(this.defaultTemplateComSacadorAvalista)) {
            this.defaultTemplateComSacadorAvalista = this.loadPdf(BOLETO_TEMPLATE_COM_SACADOR_AVALISTA);
        }
        return this.defaultTemplateComSacadorAvalista;
    }

    public byte[] getTemplateSemSacadorAvalista() {
        if (Objects.isNull(this.defaultTemplateSemSacadorAvalista)) {
            this.defaultTemplateSemSacadorAvalista = this.loadPdf(BOLETO_TEMPLATE_SEM_SACADOR_AVALISTA);
        }
        return this.defaultTemplateSemSacadorAvalista;
    }

    public Image getLogotipoDoBanco(String codigo) {
        Image logo = this.imagensLogoBanco.get(codigo);
        if (Objects.isNull(logo)) {
            logo = this.loadLogotipoDoBanco(codigo);
            this.imagensLogoBanco.put(codigo, logo);
        }
        return logo;
    }

    private BufferedImage loadLogotipoDoBanco(String codigo) {
        String path = "/img/%s.png";
        Strings.checkNotBlank(codigo, "Codigo do banco n\u00e3o informado!");
        String logo = String.format("/img/%s.png", codigo);
        URL url = ClassLoaders.getResource(logo, this.getClass());
        Objects.checkNotNull(url, String.format("Logo n\u00e3o \"%s\" n\u00e3o encontrada!", logo));
        BufferedImage imageLogo = null;
        try {
            imageLogo = ImageIO.read(url);
            Objects.checkNotNull(imageLogo);
        }
        catch (IOException e) {
            Exceptions.throwIllegalStateException("Erro ao tentar ler a imagem logotipo do banco " + codigo, e);
        }
        return imageLogo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadPdf(String fileName) {
        byte[] pdf = null;
        InputStream is = null;
        try {
            is = ClassLoaders.getResource("/pdf/" + fileName, this.getClass()).openStream();
            pdf = Files.toByteArray(is);
        }
        catch (Exception e) {
            Exceptions.throwIllegalStateException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    Exceptions.throwIllegalStateException(e);
                }
            }
        }
        return pdf;
    }
}

