/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.view;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.BarcodeInter25;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.jrimum.bopepo.BancosSuportados;
import org.jrimum.bopepo.Guia;
import org.jrimum.bopepo.view.GuiaViewer;
import org.jrimum.domkee.banco.Convenio;
import org.jrimum.domkee.banco.OrgaoRecebedor;
import org.jrimum.domkee.banco.TipoValorReferencia;
import org.jrimum.utilix.DateUtil;
import org.jrimum.utilix.FileUtil;
import org.jrimum.utilix.MonetaryUtil;
import org.jrimum.utilix.Objects;
import org.jrimum.utilix.PDFUtil;
import org.jrimum.utilix.RectanglePDF;

class ViewerPDF {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(ViewerPDF.class);
    private static URL TEMPLATE_PADRAO = ViewerPDF.class.getResource("/pdf/GuiaTemplate.pdf");
    private static URL TEMPLATE_PADRAO_SEM_BANCO = ViewerPDF.class.getResource("/pdf/GuiaTemplateSemBanco.pdf");
    private PdfReader reader;
    private PdfStamper stamper;
    private AcroFields form;
    private ByteArrayOutputStream outputStream;
    private Guia guia;
    private File template;

    ViewerPDF() {
    }

    ViewerPDF(Guia guia) {
        this.guia = guia;
    }

    ViewerPDF(Guia guia, File template) {
        this.guia = guia;
        this.setTemplate(template);
    }

    protected static File groupInOnePDF(String pathName, List<Guia> guias, GuiaViewer guiaViewer) {
        File arq = null;
        ArrayList<byte[]> guiasEmBytes = new ArrayList<byte[]>(guias.size());
        for (Guia guia : guias) {
            guiasEmBytes.add(guiaViewer.setGuia(guia).getPdfAsByteArray());
        }
        try {
            arq = FileUtil.bytes2File(pathName, PDFUtil.mergeFiles(guiasEmBytes));
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Erro durante gera\u00e7\u00e3o do PDF." + e.getLocalizedMessage()), (Throwable)e);
            throw new RuntimeException("Erro durante gera\u00e7\u00e3o do PDF. Causado por " + e.getLocalizedMessage(), e);
        }
        catch (IOException e) {
            log.error((Object)("Erro durante gera\u00e7\u00e3o do PDF." + e.getLocalizedMessage()), (Throwable)e);
            throw new RuntimeException("Erro durante gera\u00e7\u00e3o do PDF. Causado por " + e.getLocalizedMessage(), e);
        }
        return arq;
    }

    protected static List<File> onePerPDF(String path, String extensao, List<Guia> guias) {
        ArrayList<File> arquivos = new ArrayList<File>(guias.size());
        int cont = 1;
        for (Guia guia : guias) {
            arquivos.add(new GuiaViewer(guia).getPdfAsFile(path + "Guia" + cont++ + extensao));
        }
        return arquivos;
    }

    protected File getFile(String pathName) {
        File file = null;
        try {
            this.processarPdf();
            file = FileUtil.bytes2File(pathName, this.outputStream.toByteArray());
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Erro ao tentar acessar arquivo inexistente. " + e.getLocalizedMessage()), (Throwable)e);
            throw new RuntimeException("Erro ao tentar acessar arquivo inexistente: [" + pathName + "]. Causado por " + e.getLocalizedMessage(), e);
        }
        catch (IOException e) {
            log.error((Object)("Erro durante a cria\u00e7\u00e3o do arquivo. " + e.getLocalizedMessage()), (Throwable)e);
            throw new RuntimeException("Erro durante a cria\u00e7\u00e3o do arquivo: [" + pathName + "]. Causado por " + e.getLocalizedMessage(), e);
        }
        catch (DocumentException e) {
            log.error((Object)("Erro durante a cria\u00e7\u00e3o do arquivo. " + e.getLocalizedMessage()), (Throwable)e);
            throw new RuntimeException("Erro durante a cria\u00e7\u00e3o do arquivo: [" + pathName + "]. Causado por " + e.getLocalizedMessage(), e);
        }
        return file;
    }

    protected ByteArrayOutputStream getStream() {
        ByteArrayOutputStream baos = null;
        try {
            this.processarPdf();
            baos = FileUtil.bytes2Stream(this.outputStream.toByteArray());
        }
        catch (IOException e) {
            log.error((Object)("Erro durante a cria\u00e7\u00e3o do stream. " + e.getLocalizedMessage()), (Throwable)e);
            throw new RuntimeException("Erro durante a cria\u00e7\u00e3o do stream. Causado por " + e.getLocalizedMessage(), e);
        }
        catch (DocumentException e) {
            log.error((Object)("Erro durante a cria\u00e7\u00e3o do stream. " + e.getLocalizedMessage()), (Throwable)e);
            throw new RuntimeException("Erro durante a cria\u00e7\u00e3o do stream. Causado por " + e.getLocalizedMessage(), e);
        }
        return baos;
    }

    protected byte[] getBytes() {
        byte[] bytes = null;
        try {
            this.processarPdf();
            bytes = this.outputStream.toByteArray();
        }
        catch (IOException e) {
            log.error((Object)("Erro durante a cria\u00e7\u00e3o do stream. " + e.getLocalizedMessage()), (Throwable)e);
            throw new RuntimeException("Erro durante a cria\u00e7\u00e3o do stream. Causado por " + e.getLocalizedMessage(), e);
        }
        catch (DocumentException e) {
            log.error((Object)("Erro durante a cria\u00e7\u00e3o do stream. " + e.getLocalizedMessage()), (Throwable)e);
            throw new RuntimeException("Erro durante a cria\u00e7\u00e3o do stream. Causado por " + e.getLocalizedMessage(), e);
        }
        return bytes;
    }

    protected File getTemplate() {
        return this.template;
    }

    protected void setTemplate(File template) {
        this.template = template;
    }

    protected void setTemplate(String pathname) {
        this.setTemplate(new File(pathname));
    }

    protected Guia getGuia() {
        return this.guia;
    }

    private void processarPdf() throws IOException, DocumentException {
        this.inicializar();
        this.preencher();
        this.finalizar();
    }

    private URL getTemplateFromResource() {
        URL templateFromResource = null;
        templateFromResource = Objects.isNotNull(this.guia.getArrecadacao().getConvenio()) && Objects.isNotNull(this.guia.getArrecadacao().getConvenio().getBanco()) ? TEMPLATE_PADRAO : TEMPLATE_PADRAO_SEM_BANCO;
        return templateFromResource;
    }

    private boolean isTemplateFromResource() {
        return Objects.isNull(this.getTemplate());
    }

    private void inicializar() throws IOException, DocumentException {
        this.reader = this.isTemplateFromResource() ? new PdfReader(this.getTemplateFromResource()) : new PdfReader(this.getTemplate().getAbsolutePath());
        this.outputStream = new ByteArrayOutputStream();
        this.stamper = new PdfStamper(this.reader, (OutputStream)this.outputStream);
        this.form = this.stamper.getAcroFields();
    }

    private void finalizar() throws DocumentException, IOException {
        this.reader.consolidateNamedDestinations();
        this.stamper.setFormFlattening(true);
        this.stamper.setRotateContents(true);
        this.reader.removeFields();
        this.stamper.setFullCompression();
        this.reader.eliminateSharedStreams();
        this.outputStream.flush();
        this.outputStream.close();
        this.reader.close();
        this.stamper.close();
    }

    private void preencher() throws MalformedURLException, IOException, DocumentException {
        this.setLogoBanco();
        this.setLogoOrgaoRecebedor();
        this.setContribuinteNome();
        this.setContribuinteCPF();
        this.setDescricao();
        this.setTitulo();
        this.setNossoNumero();
        this.setValorDocumento();
        this.setDataDocumento();
        this.setDataVencimeto();
        this.setInstrucaoAoCaixa();
        this.setLinhaDigitavel();
        this.setCodigoBarra();
        this.setCamposExtra();
        this.setImagensNosCampos();
    }

    private void setCamposExtra() throws IOException, DocumentException {
        if (Objects.isNotNull(this.guia.getTextosExtras())) {
            for (String campo : this.guia.getTextosExtras().keySet()) {
                this.form.setField(campo, this.guia.getTextosExtras().get(campo));
            }
        }
    }

    private void setCodigoBarra() throws DocumentException {
        BarcodeInter25 barCode = new BarcodeInter25();
        barCode.setCode(this.guia.getCodigoDeBarras().write());
        barCode.setExtended(true);
        barCode.setBarHeight(40.0f);
        barCode.setFont(null);
        barCode.setN(3.0f);
        PdfContentByte cb = null;
        List posCampoImgLogo = this.form.getFieldPositions("txtCodigoBarra");
        if (Objects.isNotNull(posCampoImgLogo)) {
            for (AcroFields.FieldPosition pos : posCampoImgLogo) {
                RectanglePDF field = new RectanglePDF(pos.position);
                cb = this.stamper.getOverContent(field.getPage());
                com.itextpdf.text.Image imgBarCode = barCode.createImageWithBarcode(cb, null, null);
                PDFUtil.changeField2Image(this.stamper, field, imgBarCode);
            }
        }
    }

    private void setDataDocumento() throws IOException, DocumentException {
        this.form.setField("txtDataDocumento", DateUtil.FORMAT_DD_MM_YYYY.format(this.guia.getArrecadacao().getDataDoDocumento()));
    }

    private void setInstrucaoAoCaixa() throws IOException, DocumentException {
        this.form.setField("txtInstrucaoAoCaixa1", this.guia.getInstrucaoAoCaixa1());
        this.form.setField("txtInstrucaoAoCaixa2", this.guia.getInstrucaoAoCaixa2());
        this.form.setField("txtInstrucaoAoCaixa3", this.guia.getInstrucaoAoCaixa3());
    }

    private void setValorDocumento() throws IOException, DocumentException {
        String valorStr = null;
        valorStr = this.guia.getArrecadacao().getTipoValorReferencia() == TipoValorReferencia.VALOR_COBRADO_EM_REAL_COM_DV_MODULO_10 || this.guia.getArrecadacao().getTipoValorReferencia() == TipoValorReferencia.VALOR_COBRADO_EM_REAL_COM_DV_MODULO_11 ? MonetaryUtil.FORMAT_REAL_COM_PREFIXO.format(this.guia.getArrecadacao().getValorDocumento()) : MonetaryUtil.FORMAT_REAL.format(this.guia.getArrecadacao().getValorDocumento());
        this.form.setField("txtValorDocumento1", valorStr);
        this.form.setField("txtValorDocumento2", valorStr);
        this.form.setField("txtValorDocumento3", valorStr);
    }

    private void setDataVencimeto() throws IOException, DocumentException {
        String dataFormatada = DateUtil.FORMAT_DD_MM_YYYY.format(this.guia.getArrecadacao().getDataDoVencimento());
        this.form.setField("txtDataVencimento", dataFormatada);
        this.form.setField("txtDataVencimento1", dataFormatada);
        this.form.setField("txtDataVencimento2", dataFormatada);
        this.form.setField("txtDataVencimento3", dataFormatada);
    }

    private void setContribuinteNome() throws IOException, DocumentException {
        this.form.setField("txtContribuinteNome", this.guia.getArrecadacao().getContribuinte().getNome());
    }

    private void setContribuinteCPF() throws IOException, DocumentException {
        this.form.setField("txtContribuinteCPF", this.guia.getArrecadacao().getContribuinte().getCPF().getCodigoFormatado());
    }

    private void setDescricao() throws IOException, DocumentException {
        this.form.setField("txtDescricao", this.guia.getArrecadacao().getDescricao());
    }

    private void setTitulo() throws IOException, DocumentException {
        this.form.setField("txtTitulo", this.guia.getArrecadacao().getTitulo());
    }

    private void setLinhaDigitavel() throws DocumentException, IOException {
        this.form.setField("txtLinhaDigitavel", this.guia.getLinhaDigitavel().write());
    }

    private void setLogoBanco() throws MalformedURLException, IOException, DocumentException {
        Convenio convenio = this.guia.getArrecadacao().getConvenio();
        com.itextpdf.text.Image imgLogoBanco = null;
        if (Objects.isNotNull(convenio) && Objects.isNotNull(convenio.getBanco())) {
            if (Objects.isNotNull(convenio.getBanco().getImgLogo())) {
                imgLogoBanco = com.itextpdf.text.Image.getInstance((Image)convenio.getBanco().getImgLogo(), null);
                this.setImageLogo(imgLogoBanco);
            } else if (BancosSuportados.isSuportado(convenio.getBanco().getCodigoDeCompensacaoBACEN().getCodigoFormatado())) {
                URL url = this.getClass().getResource("/img/" + convenio.getBanco().getCodigoDeCompensacaoBACEN().getCodigoFormatado() + ".png");
                if (Objects.isNotNull(url)) {
                    imgLogoBanco = com.itextpdf.text.Image.getInstance((URL)url);
                }
                if (Objects.isNotNull(imgLogoBanco)) {
                    convenio.getBanco().setImgLogo(ImageIO.read(url));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Banco sem imagem da logo informada. Com base no c\u00f3digo do banco, uma imagem foi encontrada no resource e est\u00e1 sendo utilizada.");
                }
                this.setImageLogo(imgLogoBanco);
            } else {
                log.warn((Object)"Banco sem imagem definida. O nome da institui\u00e7\u00e3o ser\u00e1 usado como logo.");
                this.form.setField("txtLogoBanco", convenio.getBanco().getNome());
            }
        }
    }

    private void setLogoOrgaoRecebedor() throws MalformedURLException, IOException, DocumentException {
        com.itextpdf.text.Image imgLogoBanco = null;
        OrgaoRecebedor orgaoRecebedor = this.guia.getArrecadacao().getOrgaoRecebedor();
        if (Objects.isNotNull(orgaoRecebedor.getImgLogo())) {
            imgLogoBanco = com.itextpdf.text.Image.getInstance((Image)orgaoRecebedor.getImgLogo(), null);
            this.setImagemNoCampo("txtLogoOrgaoRecebedor1", imgLogoBanco);
            this.setImagemNoCampo("txtLogoOrgaoRecebedor2", imgLogoBanco);
        }
    }

    private void setImagensNosCampos() throws DocumentException, IOException {
        if (Objects.isNotNull(this.guia.getImagensExtras())) {
            for (String campo : this.guia.getImagensExtras().keySet()) {
                this.setImagemNoCampo(campo, com.itextpdf.text.Image.getInstance((Image)this.guia.getImagensExtras().get(campo), null));
            }
        }
    }

    private void setImagemNoCampo(String nomeDoCampo, com.itextpdf.text.Image imagem) throws DocumentException {
        List posCampoImgLogo;
        if (StringUtils.isNotBlank((CharSequence)nomeDoCampo) && Objects.isNotNull(posCampoImgLogo = this.form.getFieldPositions(nomeDoCampo))) {
            for (AcroFields.FieldPosition fpos : posCampoImgLogo) {
                PDFUtil.changeField2Image(this.stamper, new RectanglePDF(fpos.position), imagem);
            }
        }
    }

    private void setImageLogo(com.itextpdf.text.Image imgLogoBanco) throws DocumentException {
        this.setImagemNoCampo("txtLogoBanco", imgLogoBanco);
    }

    private void setNossoNumero() throws IOException, DocumentException {
        this.form.setField("txtNossoNumero", this.guia.getArrecadacao().getNossoNumero());
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder((Object)this);
        tsb.append((Object)this.guia);
        return tsb.toString();
    }
}

