/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.domkee.banco;

import org.apache.commons.lang3.StringUtils;
import org.jrimum.domkee.banco.IAgencia;
import org.jrimum.utilix.Exceptions;
import org.jrimum.utilix.Objects;

public class Agencia
implements IAgencia<Integer, String> {
    private final Integer codigo;
    private final String digitoVerificador;

    public Agencia(Integer codigo) {
        this.codigo = codigo;
        this.verifyCodigo();
        this.digitoVerificador = "";
    }

    public Agencia(Integer codigo, String digito) {
        this.codigo = codigo;
        this.verifyCodigo();
        this.digitoVerificador = digito;
        this.verifyDv();
    }

    public void verifyCodigo() {
        if (this.codigo < 0) {
            Exceptions.throwIllegalArgumentException("O c\u00f3digo da ag\u00eancia deve ser um inteiro natural (incluindo zero)");
        }
        if (String.valueOf(this.codigo).length() > 5) {
            Exceptions.throwIllegalArgumentException("O c\u00f3digo da ag\u00eancia deve possuir de 1 a 5 d\u00edgitos");
        }
    }

    public void verifyDv() {
        if (StringUtils.isBlank((CharSequence)this.digitoVerificador)) {
            Exceptions.throwIllegalArgumentException("O d\u00edgito verificador da ag\u00eancia n\u00e3o pode ser null ou apenas espa\u00e7os em branco");
        }
        if (this.digitoVerificador.length() > 1) {
            Exceptions.throwIllegalArgumentException("O d\u00edgito verificador da ag\u00eancia deve possuir apenas um d\u00edgito");
        }
        if (!StringUtils.isAlphanumeric((CharSequence)this.digitoVerificador)) {
            Exceptions.throwIllegalArgumentException("O d\u00edgito verificador da ag\u00eancia deve ser letra ou d\u00edgito");
        }
    }

    @Override
    public Integer getCodigo() {
        return this.codigo;
    }

    @Override
    public String getDigitoVerificador() {
        return this.digitoVerificador;
    }

    public String toString() {
        return Objects.toString(this);
    }
}

