/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.domkee.banco;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import org.jrimum.JRimumException;
import org.jrimum.domkee.banco.Contribuinte;
import org.jrimum.domkee.banco.Convenio;
import org.jrimum.domkee.banco.OrgaoRecebedor;
import org.jrimum.domkee.banco.TipoProduto;
import org.jrimum.domkee.banco.TipoValorReferencia;
import org.jrimum.utilix.Objects;

public class Arrecadacao
implements Serializable {
    private static final long serialVersionUID = -466289033349771721L;
    public static final TipoProduto TIPO_PRODUTO = TipoProduto.ARRECADACAO;
    private String titulo;
    private String descricao;
    private String numeroDoDocumento;
    private Date dataDoDocumento;
    private Date dataDoVencimento;
    private BigDecimal valorDocumento;
    private TipoValorReferencia tipoValorReferencia;
    private BigDecimal valorDesconto;
    private String nossoNumero;
    private Convenio convenio;
    private OrgaoRecebedor orgaoRecebedor;
    private Contribuinte contribuinte;

    public Arrecadacao(OrgaoRecebedor orgaoRecebedor, Contribuinte contribuinte) {
        this.setOrgaoRecebedor(orgaoRecebedor);
        this.setContribuinte(contribuinte);
    }

    public Arrecadacao(OrgaoRecebedor orgaoRecebedor, Contribuinte contribuinte, Convenio convenio) {
        this.setOrgaoRecebedor(orgaoRecebedor);
        this.setContribuinte(contribuinte);
        this.setConvenio(convenio);
    }

    public String getTitulo() {
        return this.titulo;
    }

    public void setTitulo(String titulo) {
        this.titulo = titulo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getNumeroDoDocumento() {
        return this.numeroDoDocumento;
    }

    public void setNumeroDoDocumento(String numeroDoDocumento) {
        this.numeroDoDocumento = numeroDoDocumento;
    }

    public Date getDataDoDocumento() {
        return this.dataDoDocumento;
    }

    public void setDataDoDocumento(Date dataDoDocumento) {
        this.dataDoDocumento = dataDoDocumento;
    }

    public Date getDataDoVencimento() {
        return this.dataDoVencimento;
    }

    public void setDataDoVencimento(Date dataDoVencimento) {
        this.dataDoVencimento = dataDoVencimento;
    }

    public BigDecimal getValorDocumento() {
        return this.valorDocumento;
    }

    public void setValorDocumento(BigDecimal valorDocumento) {
        this.valorDocumento = valorDocumento;
    }

    public BigDecimal getValorDesconto() {
        return this.valorDesconto;
    }

    public void setValorDesconto(BigDecimal valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    public String getNossoNumero() {
        return this.nossoNumero;
    }

    public void setNossoNumero(String nossoNumero) {
        this.nossoNumero = nossoNumero;
    }

    public Convenio getConvenio() {
        return this.convenio;
    }

    public void setConvenio(Convenio convenio) {
        if (!Objects.isNotNull(convenio)) {
            throw new JRimumException(new IllegalArgumentException("Conv\u00eanio n\u00e3o pode ser nulo!"));
        }
        this.convenio = convenio;
    }

    public OrgaoRecebedor getOrgaoRecebedor() {
        return this.orgaoRecebedor;
    }

    public void setOrgaoRecebedor(OrgaoRecebedor orgaoRecebedor) {
        if (!Objects.isNotNull(orgaoRecebedor)) {
            throw new JRimumException(new IllegalArgumentException("\u00d3rg\u00e3o recebedor n\u00e3o pode ser nulo!"));
        }
        this.orgaoRecebedor = orgaoRecebedor;
    }

    public Contribuinte getContribuinte() {
        return this.contribuinte;
    }

    public void setContribuinte(Contribuinte contribuinte) {
        if (!Objects.isNotNull(contribuinte)) {
            throw new JRimumException(new IllegalArgumentException("Contribuinte n\u00e3o pode ser nulo!"));
        }
        this.contribuinte = contribuinte;
    }

    public TipoValorReferencia getTipoValorReferencia() {
        return this.tipoValorReferencia;
    }

    public void setTipoValorReferencia(TipoValorReferencia tipoValorReferencia) {
        this.tipoValorReferencia = tipoValorReferencia;
    }
}

