/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.domkee.banco;

import java.awt.Image;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.jrimum.domkee.banco.CodigoDeCompensacaoBACEN;
import org.jrimum.domkee.banco.ContaBancaria;
import org.jrimum.domkee.banco.IBanco;
import org.jrimum.domkee.pessoa.CNPJ;
import org.jrimum.domkee.pessoa.CPRF;
import org.jrimum.domkee.pessoa.Endereco;
import org.jrimum.domkee.pessoa.NumeroDeTelefone;
import org.jrimum.domkee.pessoa.PessoaJuridica;
import org.jrimum.utilix.Objects;

public class Banco
implements IBanco {
    private static Logger log = Logger.getLogger(Banco.class);
    private CodigoDeCompensacaoBACEN codigoDeCompensacaoBACEN;
    private String segmento;
    private Image imgLogo;
    private PessoaJuridica pessoaJuridica;

    public Banco() {
    }

    public Banco(CodigoDeCompensacaoBACEN codigoDeCompensacaoBACEN, String instituicao) {
        this.codigoDeCompensacaoBACEN = codigoDeCompensacaoBACEN;
        this.pessoaJuridica = new PessoaJuridica();
        this.pessoaJuridica.setNome(instituicao);
        this.pessoaJuridica.setNomeFantasia(instituicao);
    }

    public Banco(CodigoDeCompensacaoBACEN codigoDeCompensacaoBACEN, String instituicao, CNPJ cnpj) {
        this.codigoDeCompensacaoBACEN = codigoDeCompensacaoBACEN;
        this.pessoaJuridica = new PessoaJuridica();
        this.pessoaJuridica.setCPRF(cnpj);
        this.pessoaJuridica.setNome(instituicao);
        this.pessoaJuridica.setNomeFantasia(instituicao);
    }

    public Banco(CodigoDeCompensacaoBACEN codigoDeCompensacaoBACEN, String instituicao, CNPJ cnpj, String segmento) {
        this.codigoDeCompensacaoBACEN = codigoDeCompensacaoBACEN;
        this.segmento = segmento;
        this.pessoaJuridica = new PessoaJuridica();
        this.pessoaJuridica.setCPRF(cnpj);
        this.pessoaJuridica.setNome(instituicao);
        this.pessoaJuridica.setNomeFantasia(instituicao);
    }

    public Banco(CodigoDeCompensacaoBACEN codigoDeCompensacaoBACEN, String instituicao, CNPJ cnpj, String segmento, Image imgLogo) {
        this.codigoDeCompensacaoBACEN = codigoDeCompensacaoBACEN;
        this.segmento = segmento;
        this.imgLogo = imgLogo;
        this.pessoaJuridica = new PessoaJuridica();
        this.pessoaJuridica.setCPRF(cnpj);
    }

    public static boolean isCodigoDeCompensacaoOK(String codigo) {
        boolean ok = false;
        if (Objects.isNotNull(codigo)) {
            if (StringUtils.isNumeric((CharSequence)codigo)) {
                if (codigo.length() == 3) {
                    ok = true;
                } else {
                    log.warn((Object)"O c\u00f3digo \u00e9 de apenas 3 digitos!");
                }
            } else {
                log.warn((Object)"O c\u00f3digo de compensa\u00e7\u00e3o deve ser num\u00e9rico!");
            }
        }
        return ok;
    }

    @Override
    public CodigoDeCompensacaoBACEN getCodigoDeCompensacaoBACEN() {
        return this.codigoDeCompensacaoBACEN;
    }

    @Override
    public void setCodigoDeCompensacaoBACEN(CodigoDeCompensacaoBACEN codigoDeCompensacaoBACEN) {
        this.codigoDeCompensacaoBACEN = codigoDeCompensacaoBACEN;
    }

    public CNPJ getCNPJ() {
        return (CNPJ)this.pessoaJuridica.getCPRF();
    }

    public void setCNPJ(CNPJ cnpj) {
        this.pessoaJuridica.setCPRF(cnpj);
    }

    @Override
    public String getSegmento() {
        return this.segmento;
    }

    @Override
    public void setSegmento(String segmento) {
        this.segmento = segmento;
    }

    @Override
    public Image getImgLogo() {
        return this.imgLogo;
    }

    @Override
    public void setImgLogo(Image imgLogo) {
        this.imgLogo = imgLogo;
    }

    @Override
    public void addEndereco(Endereco endereco) {
        this.pessoaJuridica.addEndereco(endereco);
    }

    @Override
    public void addTelefone(NumeroDeTelefone telefone) {
        this.pessoaJuridica.addTelefone(telefone);
    }

    @Override
    public CPRF getCPRF() {
        return this.pessoaJuridica.getCPRF();
    }

    @Override
    public Collection<Endereco> getEnderecos() {
        return this.pessoaJuridica.getEnderecos();
    }

    @Override
    public String getNome() {
        return this.pessoaJuridica.getNome();
    }

    @Override
    public Collection<NumeroDeTelefone> getTelefones() {
        return this.pessoaJuridica.getTelefones();
    }

    @Override
    public boolean isFisica() {
        return this.pessoaJuridica.isFisica();
    }

    @Override
    public boolean isJuridica() {
        return this.pessoaJuridica.isJuridica();
    }

    @Override
    public void setCPRF(CPRF cprf) {
        this.pessoaJuridica.setCPRF(cprf);
    }

    @Override
    public void setEnderecos(Collection<Endereco> enderecos) {
        this.pessoaJuridica.setEnderecos(enderecos);
    }

    @Override
    public void setNome(String nome) {
        this.pessoaJuridica.setNome(nome);
    }

    @Override
    public void setTelefones(Collection<NumeroDeTelefone> telefones) {
        this.pessoaJuridica.setTelefones(telefones);
    }

    @Override
    public Long getInscricaoEstadual() {
        return this.pessoaJuridica.getInscricaoEstadual();
    }

    @Override
    public Long getInscricaoMunicipal() {
        return this.pessoaJuridica.getInscricaoMunicipal();
    }

    @Override
    public String getNomeFantasia() {
        return this.pessoaJuridica.getNome();
    }

    @Override
    public void setInscricaoEstadual(Long inscricaoEstadual) {
        this.pessoaJuridica.setInscricaoEstadual(inscricaoEstadual);
    }

    @Override
    public void setInscricaoMunicipal(Long inscricaoMunicipal) {
        this.pessoaJuridica.setInscricaoMunicipal(inscricaoMunicipal);
    }

    @Override
    public void setNomeFantasia(String nomeFantasia) {
        this.pessoaJuridica.setNomeFantasia(nomeFantasia);
    }

    @Override
    public void addContaBancaria(ContaBancaria contaBancaria) {
        this.pessoaJuridica.addContaBancaria(contaBancaria);
    }

    @Override
    public Collection<ContaBancaria> getContasBancarias() {
        return this.pessoaJuridica.getContasBancarias();
    }

    @Override
    public boolean hasContaBancaria() {
        return this.pessoaJuridica.hasContaBancaria();
    }

    @Override
    public void setContasBancarias(Collection<ContaBancaria> contasBancarias) {
        this.pessoaJuridica.setContasBancarias(contasBancarias);
    }

    public String toString() {
        ToStringBuilder tb = new ToStringBuilder((Object)this);
        tb.append((Object)this.codigoDeCompensacaoBACEN);
        tb.append((Object)this.segmento);
        tb.append((Object)this.pessoaJuridica);
        return tb.toString();
    }
}

