/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.domkee.banco;

import org.jrimum.utilix.Objects;
import org.jrimum.utilix.Strings;
import org.jrimum.vallia.CodigoDeCompensacaoBancosBACENDV;

public class CodigoDeCompensacaoBACEN {
    private static final CodigoDeCompensacaoBancosBACENDV dv4Compensacao = new CodigoDeCompensacaoBancosBACENDV();
    private Integer codigo;
    private Integer digito;

    public CodigoDeCompensacaoBACEN(Integer codigo) {
        this.setCodigo(codigo);
    }

    public CodigoDeCompensacaoBACEN(String codigo) {
        this.setCodigo(codigo);
    }

    private void initDV() {
        if (dv4Compensacao.isCodigoValido(this.codigo)) {
            this.digito = dv4Compensacao.calcule(this.codigo);
        }
    }

    public String getCodigoFormatado() {
        return Strings.fillWithZeroLeft(this.getCodigo(), 3);
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        if (dv4Compensacao.isCodigoValido(codigo)) {
            this.codigo = codigo;
            this.initDV();
        }
    }

    public void setCodigo(String codigo) {
        if (dv4Compensacao.isCodigoValido(codigo)) {
            this.codigo = Integer.valueOf(codigo);
            this.initDV();
        }
    }

    public Integer getDigito() {
        return this.digito;
    }

    public String toString() {
        return Objects.toString(this);
    }
}

