/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.domkee.banco;

import org.apache.commons.lang3.StringUtils;
import org.jrimum.texgit.Filler;
import org.jrimum.utilix.Objects;

public class CodigoDeIdentificacaoFebraban {
    private static final long serialVersionUID = 4426867246160868026L;
    private Integer codigo;

    public CodigoDeIdentificacaoFebraban(Integer codigo) {
        this.setCodigo(codigo);
    }

    public CodigoDeIdentificacaoFebraban(String codigo) {
        this.setCodigo(codigo);
    }

    public String getCodigoFormatado() {
        return Filler.ZERO_LEFT.fill(this.getCodigo(), 4);
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        if (Objects.isNull(codigo)) {
            this.setCodigo("");
        } else {
            this.setCodigo(String.valueOf(codigo));
        }
    }

    public void setCodigo(String codigo) {
        if (!this.isCodigoValido(codigo)) {
            throw new IllegalArgumentException("O c\u00f3digo de identifica\u00e7\u00e3o FEBRABAN tem de ser um n\u00famero inteiro entre 0 e 9999.");
        }
        this.codigo = Integer.parseInt(codigo);
    }

    private boolean isCodigoValido(String codigo) {
        int codigoAsInteger;
        boolean result = false;
        if (StringUtils.isNotEmpty((CharSequence)codigo) && StringUtils.isNumeric((CharSequence)codigo) && (codigoAsInteger = Integer.parseInt(codigo)) > 0 && codigoAsInteger < 9999) {
            result = true;
        }
        return result;
    }

    public String toString() {
        return Objects.toString(this);
    }
}

