/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.domkee.banco;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jrimum.domkee.banco.ParametroBancario;
import org.jrimum.utilix.Objects;

public final class ParametrosBancariosMap {
    private Map<ParametroBancario<?>, Number> dadosMap;

    public ParametrosBancariosMap() {
        this.getInstance();
    }

    public ParametrosBancariosMap(ParametroBancario<?> nome, Number valor) {
        this.adicione(nome, valor);
    }

    public static boolean hasElement(ParametrosBancariosMap params) {
        return params != null && params.isNaoVazio();
    }

    public boolean contemComNome(ParametroBancario<?> nome) {
        Objects.checkNotNull(nome);
        return this.dadosMap.containsKey(nome);
    }

    public <V extends Number> boolean contemComValor(V valor) {
        Objects.checkNotNull(valor);
        return this.dadosMap.containsValue(valor);
    }

    public <V extends Number> V getValor(ParametroBancario<?> nome) {
        Objects.checkNotNull(nome);
        return (V)this.dadosMap.get(nome);
    }

    public boolean isVazio() {
        return this.dadosMap.isEmpty();
    }

    public boolean isNaoVazio() {
        return !this.isVazio();
    }

    public Set<ParametroBancario<?>> nomes() {
        return this.dadosMap.keySet();
    }

    public Collection<? extends Number> valores() {
        return this.dadosMap.values();
    }

    public Set<Map.Entry<ParametroBancario<?>, Number>> entradas() {
        return this.dadosMap.entrySet();
    }

    public ParametrosBancariosMap adicione(ParametroBancario<?> nome, Number valor) {
        Objects.checkNotNull(nome);
        Objects.checkNotNull(valor);
        this.getInstance();
        this.dadosMap.put(nome, valor);
        return this;
    }

    public ParametrosBancariosMap adicione(ParametrosBancariosMap dados) {
        Objects.checkNotNull(dados);
        this.dadosMap.putAll(dados.dadosMap);
        return this;
    }

    public <V extends Number> V remova(ParametroBancario<?> nome) {
        Objects.checkNotNull(nome);
        return (V)this.dadosMap.remove(nome);
    }

    public void limpe() {
        this.dadosMap.clear();
    }

    public int quantidade() {
        return this.dadosMap.size();
    }

    private void getInstance() {
        if (this.dadosMap == null) {
            this.dadosMap = new HashMap();
        }
    }
}

