/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.domkee.banco;

import org.jrimum.utilix.Exceptions;

public enum TipoDeTitulo {
    CH_CHEQUE(1, "CH"),
    DM_DUPLICATA_MERCANTIL(2, "DM"),
    DMI_DUPLICATA_MERCANTIL_PARA_INDICACAO(3, "DMI"),
    DS_DUPLICATA_DE_SERVICO(4, "DS"),
    DSI_DUPLICATA_DE_SERVICO_PARA_INDICACAO(5, "DSI"),
    DR_DUPLICATA_RURAL(6, "DR"),
    LC_LETRA_DE_CAMBIO(7, "LC"),
    NCC_NOTA_DE_CREDITO_COMERCIAL(8, "NCC"),
    NCE_NOTA_DE_CREDITO_A_EXPORTACAO(9, "NCE"),
    NCI_NOTA_DE_CREDITO_INDUSTRIAL(10, "NCI"),
    NCR_NOTA_DE_CREDITO_RURAL(11, "NCR"),
    NP_NOTA_PROMISSORIA(12, "NP"),
    NPR_NOTA_PROMISSORIA_RURAL(13, "NPR"),
    TM_TRIPLICATA_MERCANTIL(14, "TM"),
    TS_TRIPLICATA_DE_SERVICO(15, "TS"),
    NS_NOTA_DE_SEGURO(16, "NS"),
    RC_RECIBO(17, "RC"),
    FAT_FATURA(18, "FAT"),
    ND_NOTA_DE_DEBITO(19, "ND"),
    AP_APOLICE_DE_SEGURO(20, "AP"),
    ME_MENSALIDADE_ESCOLAR(21, "ME"),
    PC_PARCELA_DE_CONSORCIO(22, "PC"),
    NF_NOTA_FISCAL(23, "NF"),
    DD_DOCUMENTO_DE_DIVIDA(24, "DD"),
    CEDULA_DE_PRODUTO_RURAL(25, "CPR"),
    WARRANT(26, "W"),
    DIVIDA_ATIVA_DE_ESTADO(27, "DAE"),
    DIVIDA_ATIVA_DE_MUNICIPIO(28, "DAM"),
    DIVIDA_ATIVA_DA_UNIAO(29, "DAU"),
    COTA_CONDOMINIAL(30, "CC"),
    OUTROS(99, "O");

    private int codigo;
    private String sigla;

    private TipoDeTitulo(int codigo, String sigla) {
        this.codigo = codigo;
        this.sigla = sigla;
    }

    public String getSigla() {
        return this.sigla;
    }

    public int getCodigo() {
        return this.codigo;
    }

    public static TipoDeTitulo valueOfSigla(String sigla) {
        for (TipoDeTitulo t : TipoDeTitulo.values()) {
            if (!t.getSigla().equals(sigla)) continue;
            return t;
        }
        return (TipoDeTitulo)((Object)Exceptions.throwIllegalArgumentException(String.format("Nenhuma constante enum %s com sigla igual a %s!", TipoDeTitulo.class, sigla)));
    }

    public static TipoDeTitulo valueOf(int codigo) {
        for (TipoDeTitulo t : TipoDeTitulo.values()) {
            if (t.getCodigo() != codigo) continue;
            return t;
        }
        return (TipoDeTitulo)((Object)Exceptions.throwIllegalArgumentException(String.format("Nenhuma constante enum %s com c\u00f3digo igual a %s!", TipoDeTitulo.class, codigo)));
    }
}

