/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.domkee.banco;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import org.jrimum.domkee.banco.Cedente;
import org.jrimum.domkee.banco.ContaBancaria;
import org.jrimum.domkee.banco.ParametroBancario;
import org.jrimum.domkee.banco.ParametrosBancariosMap;
import org.jrimum.domkee.banco.Sacado;
import org.jrimum.domkee.banco.SacadorAvalista;
import org.jrimum.domkee.banco.TipoDeMoeda;
import org.jrimum.domkee.banco.TipoDeTitulo;
import org.jrimum.utilix.Exceptions;
import org.jrimum.utilix.Objects;

public class Titulo {
    private String numeroDoDocumento;
    private Date dataDoDocumento;
    private Date dataDoVencimento;
    private TipoDeMoeda tipoDeMoeda = TipoDeMoeda.REAL;
    private BigDecimal valor;
    private BigDecimal desconto;
    private BigDecimal mora;
    private BigDecimal deducao;
    private BigDecimal acrecimo;
    private BigDecimal valorCobrado;
    private TipoDeTitulo tipoDeDocumento;
    private String nossoNumero;
    private String digitoDoNossoNumero;
    private ContaBancaria contaBancaria;
    private Cedente cedente;
    private Sacado sacado;
    private SacadorAvalista sacadorAvalista;
    private ParametrosBancariosMap parametrosBancariosMap;
    private Aceite aceite;

    public Titulo() {
    }

    public Titulo(ContaBancaria contaBancaria, Sacado sacado, Cedente cedente) {
        this.setContaBancaria(contaBancaria);
        this.setSacado(sacado);
        this.setCedente(cedente);
    }

    public Titulo(ContaBancaria contaBancaria, Sacado sacado, Cedente cedente, SacadorAvalista sacadorAvalista) {
        this(contaBancaria, sacado, cedente);
        this.setSacadorAvalista(sacadorAvalista);
    }

    public Titulo(ContaBancaria contaBancaria, Sacado sacado, Cedente cedente, ParametrosBancariosMap parametrosBancariosMap) {
        this.setContaBancaria(contaBancaria);
        this.setSacado(sacado);
        this.setCedente(cedente);
        this.setParametrosBancarios(parametrosBancariosMap);
    }

    public Titulo(ContaBancaria contaBancaria, Sacado sacado, Cedente cedente, ParametrosBancariosMap parametrosBancariosMap, SacadorAvalista sacadorAvalista) {
        this(contaBancaria, sacado, cedente, parametrosBancariosMap);
        this.setSacadorAvalista(sacadorAvalista);
    }

    public boolean hasSacadorAvalista() {
        boolean has = false;
        if (Objects.isNotNull(this.sacadorAvalista)) {
            has = true;
        }
        return has;
    }

    public Aceite getAceite() {
        return this.aceite;
    }

    public void setAceite(Aceite aceite) {
        this.aceite = aceite;
    }

    public Date getDataDoDocumento() {
        return this.dataDoDocumento;
    }

    public void setDataDoDocumento(Date dataDoDocumento) {
        this.dataDoDocumento = dataDoDocumento;
    }

    public Date getDataDoVencimento() {
        return this.dataDoVencimento;
    }

    public void setDataDoVencimento(Date dataDoVencimento) {
        this.dataDoVencimento = dataDoVencimento;
    }

    public String getDigitoDoNossoNumero() {
        return this.digitoDoNossoNumero;
    }

    public void setDigitoDoNossoNumero(String digitoDoNossoNumero) {
        this.digitoDoNossoNumero = digitoDoNossoNumero;
    }

    public TipoDeMoeda getTipoDeMoeda() {
        return this.tipoDeMoeda;
    }

    public void setTipoDeMoeda(TipoDeMoeda tipoDeMoeda) {
        this.tipoDeMoeda = tipoDeMoeda;
    }

    public String getNossoNumero() {
        return this.nossoNumero;
    }

    public void setNossoNumero(String nossoNumero) {
        this.nossoNumero = nossoNumero;
    }

    public String getNumeroDoDocumento() {
        return this.numeroDoDocumento;
    }

    public void setNumeroDoDocumento(String numeroDoDocumento) {
        this.numeroDoDocumento = numeroDoDocumento;
    }

    public ContaBancaria getContaBancaria() {
        return this.contaBancaria;
    }

    public void setContaBancaria(ContaBancaria contaBancaria) {
        if (Objects.isNotNull(contaBancaria)) {
            this.contaBancaria = contaBancaria;
        } else {
            Exceptions.throwIllegalArgumentException("ContaBancaria n\u00e3o pode ser nula!");
        }
    }

    public Cedente getCedente() {
        return this.cedente;
    }

    public void setCedente(Cedente cedente) {
        if (Objects.isNotNull(cedente)) {
            this.cedente = cedente;
        } else {
            Exceptions.throwIllegalArgumentException("Cedente n\u00e3o pode ser nulo!");
        }
    }

    public Sacado getSacado() {
        return this.sacado;
    }

    public void setSacado(Sacado sacado) {
        if (Objects.isNotNull(sacado)) {
            this.sacado = sacado;
        } else {
            Exceptions.throwIllegalArgumentException("Sacado n\u00e3o pode ser nulo!");
        }
    }

    public SacadorAvalista getSacadorAvalista() {
        return this.sacadorAvalista;
    }

    public void setSacadorAvalista(SacadorAvalista sacadorAvalista) {
        if (Objects.isNotNull(sacadorAvalista)) {
            this.sacadorAvalista = sacadorAvalista;
        } else {
            Exceptions.throwIllegalArgumentException("SacadorAvalista n\u00e3o pode ser nulo!");
        }
    }

    public TipoDeTitulo getTipoDeDocumento() {
        return this.tipoDeDocumento;
    }

    public void setTipoDeDocumento(TipoDeTitulo tipoDeDocumento) {
        this.tipoDeDocumento = tipoDeDocumento;
    }

    public BigDecimal getValor() {
        return this.valor;
    }

    public void setValor(BigDecimal valor) {
        this.valor = valor = valor.setScale(2, RoundingMode.DOWN);
    }

    public BigDecimal getDesconto() {
        return this.desconto;
    }

    public void setDesconto(BigDecimal desconto) {
        if (desconto != null) {
            desconto = desconto.setScale(2, RoundingMode.DOWN);
        }
        this.desconto = desconto;
    }

    public BigDecimal getMora() {
        return this.mora;
    }

    public void setMora(BigDecimal mora) {
        if (mora != null) {
            mora = mora.setScale(2, RoundingMode.DOWN);
        }
        this.mora = mora;
    }

    public BigDecimal getDeducao() {
        return this.deducao;
    }

    public void setDeducao(BigDecimal deducao) {
        if (deducao != null) {
            deducao = deducao.setScale(2, RoundingMode.DOWN);
        }
        this.deducao = deducao;
    }

    public BigDecimal getAcrecimo() {
        return this.acrecimo;
    }

    public void setAcrecimo(BigDecimal acrecimo) {
        if (acrecimo != null) {
            acrecimo = acrecimo.setScale(2, RoundingMode.DOWN);
        }
        this.acrecimo = acrecimo;
    }

    public BigDecimal getValorCobrado() {
        return this.valorCobrado;
    }

    public void setValorCobrado(BigDecimal valorCobrado) {
        if (valorCobrado != null) {
            valorCobrado = valorCobrado.setScale(2, RoundingMode.DOWN);
        }
        this.valorCobrado = valorCobrado;
    }

    public boolean hasParametrosBancarios() {
        return ParametrosBancariosMap.hasElement(this.getParametrosBancarios());
    }

    public ParametrosBancariosMap getParametrosBancarios() {
        return this.parametrosBancariosMap;
    }

    public <P extends ParametroBancario<?>> void setParametrosBancarios(ParametrosBancariosMap parametrosBancariosMap) {
        this.parametrosBancariosMap = parametrosBancariosMap;
    }

    public String toString() {
        return Objects.toString(this);
    }

    public static enum Aceite {
        A,
        N;

    }
}

