/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.domkee.pessoa;

import org.jrimum.domkee.pessoa.CNPJ;
import org.jrimum.domkee.pessoa.CPF;
import org.jrimum.domkee.pessoa.CPRF;
import org.jrimum.utilix.Exceptions;
import org.jrimum.utilix.Strings;
import org.jrimum.vallia.AbstractCPRFValidator;

public abstract class AbstractCPRF
implements CPRF {
    private String codigoFormatado;
    private Long codigo;
    protected AbstractCPRFValidator autenticadorCP;

    public static <C extends AbstractCPRF> C create(Long cadastroDePessoa, AbstractCPRFValidator.TipoDeCPRF tipoDeCadastro) throws IllegalArgumentException {
        return AbstractCPRF.create(String.valueOf(cadastroDePessoa), tipoDeCadastro);
    }

    public static <C extends AbstractCPRF> C create(String cadastroDePessoa, AbstractCPRFValidator.TipoDeCPRF tipoDeCadastro) throws IllegalArgumentException {
        String codigo = null;
        if (AbstractCPRFValidator.isParametrosValidos(cadastroDePessoa, tipoDeCadastro)) {
            if (tipoDeCadastro == AbstractCPRFValidator.TipoDeCPRF.CPF) {
                codigo = Strings.fillWithZeroLeft(cadastroDePessoa, 11);
            } else if (tipoDeCadastro == AbstractCPRFValidator.TipoDeCPRF.CNPJ) {
                codigo = Strings.fillWithZeroLeft(cadastroDePessoa, 14);
            }
        }
        return AbstractCPRF.create(codigo);
    }

    public static <C extends AbstractCPRF> C create(String cadastroDePessoa) throws IllegalArgumentException {
        AbstractCPRF cp = null;
        AbstractCPRFValidator autenticadorCP = AbstractCPRFValidator.create(cadastroDePessoa);
        if (autenticadorCP.isValido()) {
            if (autenticadorCP.isFisica()) {
                cp = new CPF(autenticadorCP.getCodigoDoCadastro());
            } else if (autenticadorCP.isJuridica()) {
                cp = new CNPJ(autenticadorCP.getCodigoDoCadastro());
            }
            cp.autenticadorCP = autenticadorCP;
        } else {
            Exceptions.throwIllegalArgumentException("O cadastro de pessoa [ \"" + cadastroDePessoa + "\" ] n\u00e3o \u00e9 v\u00e1lido.");
        }
        return (C)cp;
    }

    @Override
    public boolean isFisica() {
        return this.autenticadorCP.isFisica();
    }

    @Override
    public boolean isJuridica() {
        return this.autenticadorCP.isJuridica();
    }

    protected void setCodigoFormatado(String codigoFormatado) {
        this.codigoFormatado = codigoFormatado;
    }

    protected void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    @Override
    public Long getCodigo() {
        return this.codigo;
    }

    @Override
    public String getCodigoComZeros() {
        if (this.isFisica()) {
            return Strings.fillWithZeroLeft(this.getCodigo(), 11);
        }
        return Strings.fillWithZeroLeft(this.getCodigo(), 14);
    }

    @Override
    public String getCodigoFormatado() {
        return this.codigoFormatado;
    }

    @Override
    public Long getRaiz() {
        if (this.isFisica()) {
            return Long.valueOf(this.codigoFormatado.split("-")[0].replaceAll("\\.", ""));
        }
        return Long.valueOf(this.codigoFormatado.split("/")[0].replaceAll("\\.", ""));
    }

    @Override
    public String getRaizComZeros() {
        if (this.isFisica()) {
            return Strings.fillWithZeroLeft(this.getRaiz(), 9);
        }
        return Strings.fillWithZeroLeft(this.getRaiz(), 8);
    }

    @Override
    public String getRaizFormatada() {
        if (this.isFisica()) {
            return this.codigoFormatado.split("-")[0];
        }
        return this.codigoFormatado.split("/")[0];
    }

    @Override
    public Integer getDv() {
        return Integer.valueOf(this.codigoFormatado.split("-")[1]);
    }

    @Override
    public String getDvComZeros() {
        return this.codigoFormatado.split("-")[1];
    }

    @Override
    public int compareTo(Object other) {
        if (other != null) {
            if (other instanceof AbstractCPRF) {
                AbstractCPRF cprf = (AbstractCPRF)other;
                if (this.autenticadorCP.isFisica()) {
                    return this.codigo.compareTo(cprf.codigo);
                }
                return this.autenticadorCP.getCodigoDoCadastro().compareTo(cprf.autenticadorCP.getCodigoDoCadastro());
            }
            return -1;
        }
        return 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.codigo == null ? 0 : this.codigo.hashCode());
        result = 31 * result + (this.codigoFormatado == null ? 0 : this.codigoFormatado.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractCPRF)) {
            return false;
        }
        AbstractCPRF other = (AbstractCPRF)obj;
        if (this.codigo == null ? other.codigo != null : !this.codigo.equals(other.codigo)) {
            return false;
        }
        return !(this.codigoFormatado == null ? other.codigoFormatado != null : !this.codigoFormatado.equals(other.codigoFormatado));
    }

    public String toString() {
        return this.getCodigoFormatado();
    }
}

