/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.domkee.pessoa;

import org.apache.commons.lang3.StringUtils;
import org.jrimum.ConfiguracaoJRimum;
import org.jrimum.domkee.pessoa.AbstractCPRF;
import org.jrimum.domkee.pessoa.CNPJException;
import org.jrimum.utilix.Exceptions;
import org.jrimum.utilix.Objects;
import org.jrimum.utilix.Strings;
import org.jrimum.vallia.AbstractCPRFValidator;

public class CNPJ
extends AbstractCPRF {
    public CNPJ(Long numCNPJ) {
        block5: {
            try {
                if (AbstractCPRFValidator.isParametrosValidos(String.valueOf(numCNPJ), AbstractCPRFValidator.TipoDeCPRF.CNPJ)) {
                    this.autenticadorCP = AbstractCPRFValidator.create(Strings.fillWithZeroLeft(numCNPJ, 14));
                    if (this.autenticadorCP.isValido()) {
                        this.initFromNumber(numCNPJ);
                    } else {
                        Exceptions.throwIllegalArgumentException("O cadastro de pessoa [ \"" + numCNPJ + "\" ] n\u00e3o \u00e9 v\u00e1lido.");
                    }
                }
            }
            catch (Exception e) {
                if (e instanceof CNPJException) break block5;
                throw new CNPJException(e);
            }
        }
    }

    public CNPJ(String strCNPJ) {
        this.autenticadorCP = AbstractCPRFValidator.create(strCNPJ);
        if (this.autenticadorCP.isValido()) {
            this.init(strCNPJ);
        } else {
            if (ConfiguracaoJRimum.falharEmCPRFInvalido) {
                throw new CNPJException(new IllegalArgumentException("O cadastro de pessoa [ \"" + strCNPJ + "\" ] n\u00e3o \u00e9 v\u00e1lido."));
            }
            this.init(strCNPJ);
        }
    }

    protected void init(String strCNPJ) {
        if (StringUtils.isNumeric((CharSequence)strCNPJ)) {
            this.initFromNotFormattedString(strCNPJ);
        } else {
            this.initFromFormattedString(strCNPJ);
        }
    }

    public boolean isMatriz() {
        return this.getSufixoFormatado().equals("0001");
    }

    public boolean isSufixoEquals(String sufixoFormatado) {
        Strings.checkNotNumeric(sufixoFormatado, String.format("O sufixo [%s] deve ser um n\u00famero natural diferente de zero!", sufixoFormatado));
        return this.isSufixoEquals(Integer.valueOf(sufixoFormatado));
    }

    public boolean isSufixoEquals(Integer sufixo) {
        Objects.checkNotNull(sufixo, "Sufixo nulo!");
        Objects.checkArgument(sufixo > 0, String.format("O sufixo [%s] deve ser um n\u00famero natural diferente de zero!", sufixo));
        return this.getSufixo().equals(sufixo);
    }

    public Integer getSufixo() {
        return Integer.valueOf(this.getSufixoFormatado());
    }

    public String getSufixoFormatado() {
        return this.getCodigoFormatado().split("-")[0].split("/")[1];
    }

    private void initFromNumber(Long numCNPJ) {
        try {
            this.setCodigoFormatado(this.format(Strings.fillWithZeroLeft(numCNPJ, 14)));
            this.setCodigo(numCNPJ);
        }
        catch (Exception e) {
            throw new CNPJException(e);
        }
    }

    private void initFromFormattedString(String strCNPJ) {
        try {
            this.setCodigoFormatado(strCNPJ);
            this.setCodigo(Long.parseLong(this.removeFormat(strCNPJ)));
        }
        catch (Exception e) {
            throw new CNPJException(e);
        }
    }

    private void initFromNotFormattedString(String strCNPJ) {
        try {
            this.setCodigoFormatado(this.format(strCNPJ));
            this.setCodigo(Long.parseLong(strCNPJ));
        }
        catch (Exception e) {
            throw new CNPJException(e);
        }
    }

    private String format(String strCNPJ) {
        StringBuilder codigoFormatado = new StringBuilder(strCNPJ);
        codigoFormatado.insert(2, '.');
        codigoFormatado.insert(6, '.');
        codigoFormatado.insert(10, '/');
        codigoFormatado.insert(15, '-');
        return codigoFormatado.toString();
    }

    private String removeFormat(String codigo) {
        codigo = codigo.replace(".", "");
        codigo = codigo.replace("/", "");
        codigo = codigo.replace("-", "");
        return codigo;
    }
}

