/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.domkee.pessoa;

import org.apache.commons.lang3.StringUtils;
import org.jrimum.ConfiguracaoJRimum;
import org.jrimum.domkee.pessoa.AbstractCPRF;
import org.jrimum.domkee.pessoa.CPFException;
import org.jrimum.utilix.Exceptions;
import org.jrimum.utilix.Strings;
import org.jrimum.vallia.AbstractCPRFValidator;

public class CPF
extends AbstractCPRF {
    private static final long serialVersionUID = 5910970842832308496L;

    public CPF(String strCPF) {
        this.autenticadorCP = AbstractCPRFValidator.create(strCPF);
        if (this.autenticadorCP.isValido()) {
            this.init(strCPF);
        } else {
            if (ConfiguracaoJRimum.falharEmCPRFInvalido) {
                throw new CPFException(new IllegalArgumentException("O cadastro de pessoa [ \"" + strCPF + "\" ] n\u00e3o \u00e9 v\u00e1lido."));
            }
            this.init(strCPF);
        }
    }

    protected void init(String strCPF) {
        if (StringUtils.isNumeric((CharSequence)strCPF)) {
            this.initFromNotFormattedString(strCPF);
        } else {
            this.initFromFormattedString(strCPF);
        }
    }

    public CPF(Long numCPF) {
        block6: {
            try {
                if (AbstractCPRFValidator.isParametrosValidos(String.valueOf(numCPF), AbstractCPRFValidator.TipoDeCPRF.CPF)) {
                    this.autenticadorCP = AbstractCPRFValidator.create(Strings.fillWithZeroLeft(numCPF, 11));
                    if (!this.autenticadorCP.isValido()) {
                        throw new IllegalArgumentException("O cadastro de pessoa [ " + numCPF + " ] n\u00e3o \u00e9 v\u00e1lido.");
                    }
                    this.initFromFormattedString(this.autenticadorCP.getCodigoDoCadastro());
                    if (this.autenticadorCP.isValido()) {
                        this.initFromNumber(numCPF);
                    } else {
                        Exceptions.throwIllegalArgumentException("O cadastro de pessoa [ \"" + numCPF + "\" ] n\u00e3o \u00e9 v\u00e1lido.");
                    }
                }
            }
            catch (Exception e) {
                if (e instanceof CPFException) break block6;
                throw new CPFException(e);
            }
        }
    }

    private void initFromNumber(Long numCPF) {
        try {
            this.setCodigoFormatado(this.format(Strings.fillWithZeroLeft(numCPF, 11)));
            this.setCodigo(numCPF);
        }
        catch (Exception e) {
            throw new CPFException(e);
        }
    }

    private void initFromFormattedString(String strCPF) {
        try {
            this.setCodigoFormatado(strCPF);
            this.setCodigo(Long.parseLong(this.removeFormat(strCPF)));
        }
        catch (Exception e) {
            throw new CPFException(e);
        }
    }

    private void initFromNotFormattedString(String strCPF) {
        try {
            this.setCodigoFormatado(this.format(strCPF));
            this.setCodigo(Long.parseLong(strCPF));
        }
        catch (Exception e) {
            throw new CPFException(e);
        }
    }

    private String format(String strCPF) {
        StringBuilder codigoFormatado = new StringBuilder(strCPF);
        codigoFormatado.insert(3, '.');
        codigoFormatado.insert(7, '.');
        codigoFormatado.insert(11, '-');
        return codigoFormatado.toString();
    }

    private String removeFormat(String codigo) {
        codigo = codigo.replace(".", "");
        codigo = codigo.replace("-", "");
        return codigo;
    }
}

