/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.domkee.pessoa;

import java.util.ArrayList;
import java.util.Collection;
import org.jrimum.domkee.banco.ContaBancaria;
import org.jrimum.domkee.pessoa.AbstractCPRF;
import org.jrimum.domkee.pessoa.CPRF;
import org.jrimum.domkee.pessoa.Endereco;
import org.jrimum.domkee.pessoa.IPessoa;
import org.jrimum.domkee.pessoa.NumeroDeTelefone;
import org.jrimum.domkee.pessoa.PessoaFisica;
import org.jrimum.domkee.pessoa.PessoaJuridica;
import org.jrimum.utilix.Collections;
import org.jrimum.utilix.Objects;

public class Pessoa
implements IPessoa {
    private String nome;
    private CPRF cprf;
    private Collection<NumeroDeTelefone> telefones;
    private Collection<Endereco> enderecos;
    private Collection<ContaBancaria> contasBancarias;

    public Pessoa() {
    }

    public Pessoa(String nome) {
        this.nome = nome;
    }

    public Pessoa(String nome, String cadastroDePessoa) {
        this.nome = nome;
        this.cprf = AbstractCPRF.create(cadastroDePessoa);
    }

    public Pessoa(String nome, CPRF cadastroDePessoa) {
        this.nome = nome;
        this.cprf = cadastroDePessoa;
    }

    @Override
    public void addContaBancaria(ContaBancaria contaBancaria) {
        if (Objects.isNull(this.contasBancarias)) {
            this.contasBancarias = new ArrayList<ContaBancaria>();
        }
        this.contasBancarias.add(contaBancaria);
    }

    @Override
    public boolean hasContaBancaria() {
        return Collections.hasElement(this.getContasBancarias());
    }

    @Override
    public void addEndereco(Endereco endereco) {
        if (Objects.isNull(this.enderecos)) {
            this.enderecos = new ArrayList<Endereco>();
        }
        this.enderecos.add(endereco);
    }

    @Override
    public void addTelefone(NumeroDeTelefone telefone) {
        if (Objects.isNull(this.telefones)) {
            this.telefones = new ArrayList<NumeroDeTelefone>();
        }
        this.telefones.add(telefone);
    }

    @Override
    public CPRF getCPRF() {
        return this.cprf;
    }

    public ContaBancaria getNextContaBancaria() {
        if (Collections.hasElement(this.getContasBancarias())) {
            return this.getContasBancarias().iterator().next();
        }
        return null;
    }

    @Override
    public Collection<ContaBancaria> getContasBancarias() {
        return this.contasBancarias;
    }

    public Endereco getNextEndereco() {
        if (Collections.hasElement(this.getEnderecos())) {
            return this.getEnderecos().iterator().next();
        }
        return null;
    }

    @Override
    public Collection<Endereco> getEnderecos() {
        return this.enderecos;
    }

    @Override
    public String getNome() {
        return this.nome;
    }

    public NumeroDeTelefone getNextTelefone() {
        if (Collections.hasElement(this.getTelefones())) {
            return this.getTelefones().iterator().next();
        }
        return null;
    }

    @Override
    public Collection<NumeroDeTelefone> getTelefones() {
        return this.telefones;
    }

    @Override
    public void setCPRF(CPRF cprf) {
        this.cprf = cprf;
    }

    @Override
    public void setContasBancarias(Collection<ContaBancaria> contasBancarias) {
        this.contasBancarias = contasBancarias;
    }

    @Override
    public void setEnderecos(Collection<Endereco> enderecos) {
        this.enderecos = enderecos;
    }

    @Override
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Override
    public void setTelefones(Collection<NumeroDeTelefone> telefones) {
        this.telefones = telefones;
    }

    @Override
    public boolean isFisica() {
        return this instanceof PessoaFisica;
    }

    @Override
    public boolean isJuridica() {
        return this instanceof PessoaJuridica;
    }

    public String toString() {
        return Objects.toString(this);
    }
}

