/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.domkee.pessoa;

import org.jrimum.utilix.Strings;

public enum UnidadeFederativa {
    AM("Amazonas", "AM", "Manaus"),
    PA("Par\u00e1", "PA", "Bel\u00e9m"),
    MT("Mato Grosso", "MT", "Cuiab\u00e1"),
    MG("Minas Gerais", "MG", "Belo Horizonte"),
    BA("Bahia", "BA", "Salvador"),
    MS("Mato Grosso do Sul", "MS", "Campo Grande"),
    GO("Goi\u00e1s", "GO", "Goi\u00e2nia"),
    MA("Maranh\u00e3o", "MA", "S\u00e3o Lu\u00eds"),
    RS("Rio Grande do Sul", "RS", "Porto Alegre"),
    TO("Tocantins", "TO", "Palmas"),
    PI("Piau\u00ed", "PI", "Teresina"),
    SP("S\u00e3o Paulo", "SP", "S\u00e3o Paulo"),
    RO("Rond\u00f4nia", "RO", "Porto Velho"),
    RR("Roraima", "RR", "Boa Vista"),
    PR("Paran\u00e1", "PR", "Curitiba"),
    AC("Acre", "AC", "Rio Branco"),
    CE("Cear\u00e1", "CE", "Fortaleza"),
    AP("Amap\u00e1", "AP", "Macap\u00e1"),
    PE("Pernambuco", "PE", "Recife"),
    SC("Santa Catarina", "SC", "Florian\u00f3polis"),
    PB("Para\u00edba", "PB", "Jo\u00e3o Pessoa"),
    RN("Rio Grande do Norte", "RN", "Natal"),
    ES("Esp\u00edrito Santo", "ES", "Vit\u00f3ria"),
    RJ("Rio de Janeiro", "RJ", "Rio de Janeiro"),
    AL("Alagoas", "AL", "Macei\u00f3"),
    SE("Sergipe", "SE", "Aracaju"),
    DF("Distrito Federal", "DF", "Bras\u00edlia"),
    DESCONHECIDO("", "", "");

    private String nome;
    private String sigla;
    private String capital;

    private UnidadeFederativa(String nome, String sigla, String capital) {
        this.nome = nome;
        this.sigla = sigla;
        this.capital = capital;
    }

    public String getNome() {
        return this.nome;
    }

    public String getSigla() {
        return this.sigla;
    }

    public String getCapital() {
        return this.capital;
    }

    public static UnidadeFederativa valueOfSigla(String sigla) {
        Strings.checkNotBlank(sigla, String.format("N\u00e3o existe Unidade Federativa com sigla vazia \"%s\"", sigla));
        return UnidadeFederativa.valueOf(sigla.toUpperCase());
    }
}

