/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.texgit;

import org.jrimum.texgit.AbstractStringOfFields;
import org.jrimum.texgit.FixedField;
import org.jrimum.texgit.IFixedLength;
import org.jrimum.texgit.IFixedSize;
import org.jrimum.utilix.Collections;
import org.jrimum.utilix.Objects;
import org.jrimum.utilix.StringUtil;

public class BlockOfFields
extends AbstractStringOfFields<FixedField<?>>
implements IFixedSize,
IFixedLength {
    private Integer length = 0;
    private Integer size = 0;
    private Integer instantLength;
    private boolean truncate;
    private boolean apenasDigitos;

    protected void incSize() {
        Integer n = this.size;
        this.size = this.size + 1;
    }

    protected void incLength(Integer len) {
        if (len != null) {
            this.length = this.length + len;
        }
    }

    public BlockOfFields() {
    }

    public BlockOfFields(Integer length, Integer size) {
        super(size);
        Objects.checkNotNull(length, "length");
        if (length <= 0) {
            throw new IllegalArgumentException(String.format("O comprimento do bloco [%s] deve ser um n\u00famero natural > 0!", length));
        }
        this.setLength(length);
        this.setSize(size);
    }

    @Override
    public BlockOfFields clone() throws CloneNotSupportedException {
        return (BlockOfFields)super.clone();
    }

    @Override
    public void read(String lineOfFields) {
        Objects.checkNotNull(lineOfFields, "String de leitura nula!");
        Objects.checkNotNull(this.getFields(), "Fields == null");
        Collections.checkNotEmpty(this.getFields(), "Cole\u00e7\u00e3o de fields vazia!");
        if (this.isSizeAsDefinaed() && this.isLengthWithDefinaed(lineOfFields.length())) {
            StringBuilder builder = new StringBuilder(lineOfFields);
            for (FixedField field : this.getFields()) {
                try {
                    field.read(builder.substring(0, field.getFixedLength()));
                    builder.delete(0, field.getFixedLength());
                }
                catch (Exception e) {
                    throw new IllegalStateException(String.format("Erro ao tentar ler o campo \"%s\" na posi\u00e7\u00e3o [%s] no layout do registro.", field.getName(), this.getFields().indexOf(field) + 1), e);
                }
            }
            Object var2_2 = null;
        }
    }

    @Override
    public String write() {
        Objects.checkNotNull(this.getFields(), "Fields == null");
        Collections.checkNotEmpty(this.getFields(), "Cole\u00e7\u00e3o de fields vazia!");
        String str = null;
        this.isSizeAsDefinaed();
        str = super.write();
        if (this.apenasDigitos) {
            str = StringUtil.eliminateSymbols(str);
        }
        this.instantLength = str.length();
        if (this.isTruncate() && this.instantLength > this.getFixedLength()) {
            str = str.substring(0, this.getFixedLength());
            this.instantLength = this.getFixedLength();
        }
        this.isFixedAsDefined();
        return str;
    }

    @Override
    public boolean isFixedAsDefined() throws IllegalStateException {
        return this.isSizeAsDefinaed() && this.isLengthWithDefinaed();
    }

    private boolean isLengthWithDefinaed() {
        return this.isLengthWithDefinaed(this.instantLength);
    }

    private boolean isLengthWithDefinaed(int length) {
        if (length == this.getFixedLength()) {
            return true;
        }
        throw new IllegalStateException(String.format("O comprimento da string [%s] \u00e9 incomp\u00e1tivel com o definido [%s] no layout do registro!", length, this.getFixedLength()));
    }

    private boolean isSizeAsDefinaed() {
        if (this.size() == this.getFixedSize().intValue()) {
            return true;
        }
        throw new IllegalStateException(String.format("O n\u00famero de fields [%s] \u00e9 incomp\u00e1tivel com o definido [%s]!", this.size(), this.getFixedSize()));
    }

    @Override
    public Integer getFixedLength() {
        return this.length;
    }

    protected void setLength(Integer length) {
        if (!Objects.isNotNull(length)) {
            throw new IllegalArgumentException(String.format("Comprimento inv\u00e1lido [%s]!", length));
        }
        this.length = length;
    }

    @Override
    public Integer getFixedSize() {
        return this.size;
    }

    protected void setSize(Integer size) {
        if (!Objects.isNotNull(size)) {
            throw new IllegalArgumentException(String.format("Tamanho inv\u00e1lido [%s]!", size));
        }
        this.size = size;
    }

    @Override
    public boolean isTruncate() {
        return this.truncate;
    }

    @Override
    public void setTruncate(boolean truncate) {
        this.truncate = truncate;
    }
}

