/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.texgit;

import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.jrimum.texgit.Filler;
import org.jrimum.texgit.IField;
import org.jrimum.texgit.IFiller;
import org.jrimum.texgit.TextStream;
import org.jrimum.utilix.Dates;
import org.jrimum.utilix.ObjectUtil;
import org.jrimum.utilix.Objects;
import org.jrimum.utilix.StringUtil;

public class Field<G>
implements IField<G>,
TextStream {
    protected String name;
    protected Integer length;
    private G value;
    private Format formatter;
    protected IFiller filler;
    private boolean blankAccepted;
    protected boolean truncate;
    protected boolean apenasDigitos;

    public Field() {
    }

    public Field(G value) {
        this.setValue(value);
    }

    public Field(G value, Format formatter) {
        this.setValue(value);
        this.setFormatter(formatter);
    }

    public Field(String name, G value) {
        this.setName(name);
        this.setValue(value);
    }

    public Field(String name, G value, Format formatter) {
        this.setName(name);
        this.setValue(value);
        this.setFormatter(formatter);
    }

    @Override
    public Field<G> clone() throws CloneNotSupportedException {
        return (Field)super.clone();
    }

    @Override
    public void read(String str) {
        Objects.checkNotNull(str, "String inv\u00e1lida [null]!");
        if (str.length() != this.length.intValue()) {
            throw new IllegalArgumentException("O tamanho da String [ " + str + " ] \u00e9 incompat\u00edvel com o especificado [ " + this.length + " ]!");
        }
        Class valueType = String.class;
        try {
            if (this.value != null) {
                valueType = this.value.getClass();
            } else {
                Class tmpValueType = Field.getGenericTypeArgument(this.getClass(), 0);
                if (tmpValueType != null) {
                    valueType = tmpValueType;
                }
            }
        }
        catch (Exception tmpValueType) {
            // empty catch block
        }
        try {
            if (this.value instanceof TextStream || TextStream.class.isAssignableFrom(valueType)) {
                TextStream reader = (TextStream)this.value;
                reader.read(str);
            } else if (this.value instanceof BigDecimal || BigDecimal.class.isAssignableFrom(valueType)) {
                this.readDecimalField(str);
            } else if (this.value instanceof Date || Date.class.isAssignableFrom(valueType)) {
                this.readDateField(str);
            } else if (this.value instanceof Character || Character.class.isAssignableFrom(valueType)) {
                this.readCharacter(str);
            } else if (this.value instanceof Number || Number.class.isAssignableFrom(valueType)) {
                this.readNumeric(valueType, str);
            } else {
                this.readStringOrNumericField(str);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Falha na leitura do campo! %s", this.toString()), e);
        }
    }

    private void readCharacter(String str) {
        if (str.length() != 1) {
            throw new IllegalArgumentException("String com mais de 1 character!");
        }
        this.value = new Character(str.charAt(0));
    }

    private void readDecimalField(String str) {
        DecimalFormat decimalFormat = (DecimalFormat)this.formatter;
        try {
            String number = this.parseNumber(str);
            Long parsedValue = (Long)this.formatter.parseObject(number);
            BigDecimal decimalValue = new BigDecimal(parsedValue);
            decimalValue = decimalValue.movePointLeft(decimalFormat.getMaximumFractionDigits());
            this.value = decimalValue;
        }
        catch (ParseException e) {
            this.throwReadError(e, str);
        }
    }

    private void readDateField(String str) {
        try {
            if (StringUtils.isBlank((CharSequence)str)) {
                if (this.isBlankAccepted()) {
                    this.value = Dates.invalidDate();
                } else {
                    new IllegalArgumentException(String.format("Campo data vazio n\u00e3o permitido: [%s]!", str));
                }
            } else {
                this.value = this.formatter.parseObject(str);
            }
        }
        catch (ParseException e) {
            this.throwReadError(e, str);
        }
    }

    private void readStringOrNumericField(String str) {
        str = this.parseNumber(str);
        this.value = str;
    }

    public static <T> Class<T> getGenericTypeArgument(Class<?> clazz, int idx) {
        ParameterizedType paramType;
        Type type = clazz.getGenericSuperclass();
        try {
            paramType = (ParameterizedType)type;
        }
        catch (ClassCastException cause) {
            paramType = (ParameterizedType)((Class)type).getGenericSuperclass();
        }
        return (Class)paramType.getActualTypeArguments()[idx];
    }

    private void readNumeric(Class<?> clazz, String str) {
        for (Constructor<?> cons : clazz.getConstructors()) {
            if (cons.getParameterTypes().length != 1 || !cons.getParameterTypes()[0].equals(String.class)) continue;
            try {
                this.value = cons.newInstance(str);
            }
            catch (Exception e) {
                this.throwReadError(e, str);
            }
        }
    }

    protected String truncate(String str) {
        if (this.truncate && this.length != null && str.length() > this.length) {
            str = str.substring(0, this.length);
        }
        return str;
    }

    protected String fill(String str) {
        if (this.length != null && ObjectUtil.isNotNull(this.filler)) {
            str = this.filler.fill(str, (int)this.length);
        }
        return str;
    }

    @Override
    public String write() {
        try {
            String str = null;
            if (this.value instanceof TextStream) {
                TextStream its = (TextStream)this.value;
                str = (String)its.write();
            } else {
                str = this.value instanceof Date ? this.writeDateField() : (this.value instanceof Number ? this.writeDecimalField() : this.value.toString());
            }
            if (this.apenasDigitos) {
                str = StringUtil.eliminateSymbols(str);
            }
            str = this.fill(str);
            if (this.length != null && str.length() != this.length.intValue() && !this.truncate) {
                throw new IllegalArgumentException("O campo [ " + str + " ] \u00e9 incompat\u00edvel com o especificado [" + this.length + "]!");
            }
            return StringUtil.eliminateAccent(str).toUpperCase();
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Falha na escrita do campo escrita! %s", this.toString()), e);
        }
    }

    private String writeDecimalField() {
        Object ret = "" + this.value;
        if (this.value instanceof BigDecimal) {
            BigDecimal decimalValue = (BigDecimal)this.value;
            if (this.formatter == null) {
                this.formatter = NumberFormat.getInstance();
            }
            decimalValue = decimalValue.movePointRight(((DecimalFormat)this.formatter).getMaximumFractionDigits());
            ret = decimalValue.toString();
        } else if (this.value instanceof Number && this.formatter != null) {
            ret = this.formatter.format(this.value);
        }
        return ret;
    }

    private String writeDateField() {
        if (!Dates.equalsInvalidDate((Date)this.value)) {
            return this.formatter.format(this.value);
        }
        return "";
    }

    private String parseNumber(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            if (this.isBlankAccepted()) {
                str = "0";
            } else {
                new IllegalArgumentException(String.format("Campo num\u00e9rico vazio n\u00e3o permitido: [%s]!", str));
            }
        } else if (!StringUtils.isNumeric((CharSequence)str)) {
            new IllegalArgumentException(String.format("O campo deve ser num\u00e9rico e n\u00e3o: [%s]!", str));
        }
        return str;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (!ObjectUtil.isNotNull(name)) {
            throw new IllegalArgumentException(String.format("Nome Inv\u00e1lido: [%s]!", name));
        }
        this.name = name;
    }

    @Override
    public boolean isBlankAccepted() {
        return this.blankAccepted;
    }

    @Override
    public void setBlankAccepted(boolean blankAccepted) {
        this.blankAccepted = blankAccepted;
    }

    @Override
    public G getValue() {
        return this.value;
    }

    @Override
    public void setValue(G value) {
        if (!ObjectUtil.isNotNull(value)) {
            throw new IllegalArgumentException(String.format("Valor Inv\u00e1lido: [%s]!", value));
        }
        this.value = value;
    }

    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        if (length <= 0) {
            throw new IllegalArgumentException("Tamanho inv\u00e1lido [ " + length + " ]!");
        }
        this.length = length;
    }

    @Override
    public Format getFormatter() {
        return this.formatter;
    }

    @Override
    public void setFormatter(Format formatter) {
        if (!ObjectUtil.isNotNull(formatter)) {
            throw new IllegalArgumentException(String.format("Formato inv\u00e1lido: [%s]!", formatter));
        }
        this.formatter = formatter;
    }

    public IFiller getFiller() {
        return this.filler;
    }

    public void setFiller(Filler<?> filler) {
        if (!ObjectUtil.isNotNull(filler)) {
            throw new IllegalArgumentException("Filler inv\u00e1lido [ " + filler + " ]!");
        }
        this.filler = filler;
    }

    private void throwReadError(Exception e, String value) {
        throw new IllegalArgumentException(String.format("Falha na leitura da string: [\"%s\"]! %s", value, this.toString()), e);
    }

    public String toString() {
        return String.format("Field [name=\"%s\", value=\"%s\", isBlankAccepted=%s, apenasDigitos=%s, formatter=%s]", Objects.whenNull(this.name, ""), Objects.whenNull(this.value, ""), this.apenasDigitos, Objects.whenNull(this.isBlankAccepted(), ""), Objects.whenNull(this.formatter, ""));
    }
}

