/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.texgit;

import org.apache.commons.lang3.StringUtils;
import org.jrimum.texgit.IFiller;
import org.jrimum.texgit.Side;
import org.jrimum.texgit.TextStream;
import org.jrimum.utilix.Objects;

public class Filler<G>
implements IFiller {
    private static final long serialVersionUID = -3996934478582358340L;
    public static final Filler<Integer> ZERO_LEFT = new Filler<Integer>(0, Side.LEFT);
    public static final Filler<Integer> ZERO_RIGHT = new Filler<Integer>(0, Side.RIGHT);
    public static final Filler<String> WHITE_SPACE_LEFT = new Filler<String>(" ", Side.LEFT);
    public static final Filler<String> WHITE_SPACE_RIGHT = new Filler<String>(" ", Side.RIGHT);
    private G padding;
    private Side sideToFill;

    public Filler() {
    }

    public Filler(G fillWith) {
        this.setPadding(fillWith);
        this.setSideToFill(Side.LEFT);
    }

    public Filler(G fillWith, Side sideToFill) {
        this.setPadding(fillWith);
        this.setSideToFill(sideToFill);
    }

    public G getFillWith() {
        return this.getPadding();
    }

    public void setFillWith(G fillWith) {
        this.setPadding(fillWith);
    }

    public void setPadding(G fillWith) {
        if (!Objects.isNotNull(fillWith)) {
            throw new IllegalArgumentException(String.format("Preenchimento inv\u00e1lido [%s]!", fillWith));
        }
        this.padding = fillWith;
    }

    public G getPadding() {
        return this.padding;
    }

    public Side getSideToFill() {
        return this.sideToFill;
    }

    public void setSideToFill(Side sideToFill) {
        if (!Objects.isNotNull((Object)sideToFill)) {
            throw new IllegalArgumentException(String.format("Lado para preenchimento [%s]!", new Object[]{sideToFill}));
        }
        this.sideToFill = sideToFill;
    }

    @Override
    public String fill(String toFill, int length) {
        String str = null;
        switch (this.sideToFill) {
            case LEFT: {
                str = this.fillLeft(toFill, length);
                break;
            }
            case RIGHT: {
                str = this.fillRight(toFill, length);
            }
        }
        return str;
    }

    @Override
    public String fill(long tofill, int length) {
        return this.fill(String.valueOf(tofill), length);
    }

    @Override
    public String fill(int tofill, int length) {
        return this.fill(String.valueOf(tofill), length);
    }

    @Override
    public String fill(short tofill, int length) {
        return this.fill(String.valueOf(tofill), length);
    }

    @Override
    public String fill(byte tofill, int length) {
        return this.fill(String.valueOf(tofill), length);
    }

    @Override
    public String fill(char tofill, int length) {
        return this.fill(String.valueOf(tofill), length);
    }

    @Override
    public String fill(double tofill, int length) {
        return this.fill(String.valueOf(tofill), length);
    }

    @Override
    public String fill(float tofill, int length) {
        return this.fill(String.valueOf(tofill), length);
    }

    @Override
    public String fill(Object tofill, int length) {
        String toFillTemp = null;
        if (Objects.isNotNull(tofill)) {
            toFillTemp = tofill.toString();
        }
        return this.fill(toFillTemp, length);
    }

    @Override
    public String fill(TextStream tofill, int length) {
        String toFillTemp = null;
        if (Objects.isNotNull(tofill)) {
            toFillTemp = (String)tofill.write();
        }
        return this.fill(toFillTemp, length);
    }

    private String fillRight(String toFill, int length) {
        return StringUtils.rightPad((String)toFill, (int)length, (String)this.padding.toString());
    }

    private String fillLeft(String toFill, int length) {
        return StringUtils.leftPad((String)toFill, (int)length, (String)this.padding.toString());
    }

    public String toString() {
        return String.format("Filler [padding=\"%s\", sideToFill=%s]", Objects.whenNull(this.padding, ""), Objects.whenNull((Object)this.sideToFill, ""));
    }
}

