/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.texgit;

import java.text.Format;
import org.jrimum.texgit.Field;
import org.jrimum.texgit.IFiller;
import org.jrimum.texgit.IFixedField;
import org.jrimum.utilix.Objects;

public class FixedField<G>
extends Field<G>
implements IFixedField<G> {
    protected Integer instantLength;

    public FixedField() {
    }

    public FixedField(G value, Integer length) {
        super(value);
        this.setFixedLength(length);
    }

    public FixedField(G value, Integer length, IFiller filler) {
        super(value);
        this.setFixedLength(length);
        this.setFiller(filler);
    }

    public FixedField(G value, Integer length, Format formatter) {
        super(value, formatter);
        this.setFixedLength(length);
    }

    public FixedField(G value, Integer length, Format formatter, IFiller filler) {
        super(value, formatter);
        this.setFixedLength(length);
        this.setFiller(filler);
    }

    public FixedField(String name, G value, Integer length) {
        super(name, value);
        this.setFixedLength(length);
    }

    public FixedField(String name, G value, Integer length, IFiller filler) {
        super(name, value);
        this.setFixedLength(length);
        this.setFiller(filler);
    }

    public FixedField(String name, G value, Integer length, Format formatter) {
        super(name, value, formatter);
        this.setFixedLength(length);
    }

    public FixedField(String name, G value, Integer length, Format formatter, IFiller filler) {
        super(name, value, formatter);
        this.setFixedLength(length);
        this.setFiller(filler);
    }

    @Override
    public FixedField<G> clone() throws CloneNotSupportedException {
        return (FixedField)super.clone();
    }

    @Override
    public void read(String str) {
        Objects.checkNotNull(str, "String inv\u00e1lida [null]!");
        if (str.length() != this.getFixedLength().intValue()) {
            throw new IllegalArgumentException(String.format("Tamanho da string [%s] diferente do especificado [%s]! %s", str.length(), this.getFixedLength(), this.toString()));
        }
        super.read(str);
    }

    @Override
    public String write() {
        String str = this.fill(super.write());
        this.instantLength = str.length();
        if (this.isTruncate() && this.instantLength > this.getFixedLength()) {
            str = str.substring(0, this.getFixedLength());
            this.instantLength = this.getFixedLength();
        }
        this.isFixedAsDefined();
        return str;
    }

    @Override
    public boolean isFixedAsDefined() throws IllegalStateException {
        if (this.instantLength.equals(this.getFixedLength())) {
            return true;
        }
        throw new IllegalStateException(String.format("Tamanho da string [%s] diferente do especificado [%s]! %s", this.instantLength, this.getFixedLength(), this.toString()));
    }

    @Override
    public Integer getFixedLength() {
        return this.length;
    }

    public void setFixedLength(Integer length) {
        if (!Objects.isNotNull(length) || length <= 0) {
            throw new IllegalArgumentException(String.format("Comprimento inv\u00e1lido [%s]!", length));
        }
        this.length = length;
    }

    @Override
    public void setFiller(IFiller filler) {
        if (!Objects.isNotNull(filler)) {
            throw new IllegalArgumentException(String.format("Preenchedor inv\u00e1lido [%s]!", filler));
        }
        this.filler = filler;
    }

    @Override
    public boolean isTruncate() {
        return this.truncate;
    }

    @Override
    public void setTruncate(boolean truncate) {
        this.truncate = truncate;
    }

    public boolean isApenasDigitos() {
        return this.apenasDigitos;
    }

    public void setApenasDigitos(boolean apenasDigitos) {
        this.apenasDigitos = apenasDigitos;
    }

    @Override
    public String toString() {
        return String.format("%s FixedField [length=%s, instantLength=%s, filler=%s, truncate=%s]", super.toString(), Objects.whenNull(this.length, ""), Objects.whenNull(this.instantLength, ""), Objects.whenNull(this.filler, ""), Objects.whenNull(this.truncate, ""));
    }

    public boolean equalsValue(FixedField ff) {
        return ff != null && ff.getValue() != null && ff.getValue().equals(this.getValue());
    }
}

