/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.texgit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jrimum.texgit.FixedField;
import org.jrimum.texgit.IFlatFile;
import org.jrimum.texgit.IRecord;
import org.jrimum.texgit.IRecordFactory;
import org.jrimum.texgit.Record;
import org.jrimum.utilix.Objects;

public class FlatFile
implements IFlatFile<IRecord> {
    private List<Record> records;
    private Set<String> repitablesRecords;
    private List<String> recordsOrder;
    private IRecordFactory<Record> recordFactory;

    public FlatFile(IRecordFactory<Record> iFac4Rec) {
        this.recordFactory = iFac4Rec;
        this.records = new ArrayList<Record>();
    }

    @Override
    public Record getRecord(String idName) {
        Record record = null;
        if (StringUtils.isNotBlank((CharSequence)idName) && !this.isRepitable(idName) && !this.records.isEmpty()) {
            for (Record rec : this.records) {
                if (!idName.equals(rec.getName())) continue;
                record = rec;
            }
        }
        return record;
    }

    public boolean isRepitable(String idName) {
        return Objects.isNotNull(this.repitablesRecords) && !this.repitablesRecords.isEmpty() && this.repitablesRecords.contains(idName);
    }

    @Override
    public IRecord createRecord(String idName) {
        return this.recordFactory.create(idName);
    }

    public void addRecord(Record record) {
        if (Objects.isNotNull(record)) {
            if (this.isMyRecord(record.getName())) {
                this.records.add(record);
            } else {
                throw new IllegalArgumentException("Record fora de scopo!");
            }
        }
    }

    public boolean isMyRecord(String idName) {
        boolean is = false;
        if (StringUtils.isNotBlank((CharSequence)idName) && !this.recordsOrder.isEmpty() && this.recordsOrder.contains(idName)) {
            is = true;
        }
        return is;
    }

    @Override
    public void read(List<String> str) {
        if (Objects.isNotNull(str) && !str.isEmpty()) {
            String line = null;
            int lineIndex = 0;
            FixedField<String> typeRecord = null;
            Record record = null;
            for (String id : this.recordsOrder) {
                record = this.recordFactory.create(id);
                try {
                    if (this.isRepitable(id)) {
                        boolean read = true;
                        while (read) {
                            if (Objects.isNull(record)) {
                                record = this.recordFactory.create(id);
                            }
                            if (lineIndex < str.size()) {
                                line = str.get(lineIndex);
                            }
                            typeRecord = record.readID(line);
                            read = ((String)record.getIdType().getValue()).equals(typeRecord.getValue()) && lineIndex < str.size();
                            if (!read) continue;
                            record.read(line);
                            ++lineIndex;
                            this.addRecord(record);
                            if (record.isHeadOfGroup()) {
                                lineIndex = record.readInnerRecords(str, lineIndex, this.recordFactory);
                            }
                            record = null;
                        }
                        continue;
                    }
                    if (lineIndex >= str.size()) continue;
                    line = str.get(lineIndex);
                    typeRecord = record.readID(line);
                    if (!((String)record.getIdType().getValue()).equals(typeRecord.getValue())) continue;
                    record.read(line);
                    ++lineIndex;
                    this.addRecord(record);
                    if (record.isHeadOfGroup()) {
                        lineIndex = record.readInnerRecords(str, lineIndex, this.recordFactory);
                    }
                    record = null;
                }
                catch (Exception e) {
                    throw new IllegalStateException(String.format("Erro ao tentar ler o registro \"%s\".", record.getName()), e);
                }
            }
        }
    }

    @Override
    public List<String> write() {
        return this.write("");
    }

    public List<String> write(String lineEnding) {
        ArrayList<String> out = new ArrayList<String>(this.records.size());
        for (String id : this.recordsOrder) {
            Record rec;
            if (this.isRepitable(id)) {
                rec = null;
                for (IRecord record : this.getRecords(id)) {
                    rec = (Record)Record.class.cast(record);
                    try {
                        out.add(rec.write() + lineEnding);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(String.format("Erro ao tentar escrever o registro \"%s\".", rec.getName()), e);
                    }
                    if (!rec.isHeadOfGroup() || !rec.hasInnerRecords()) continue;
                    out.addAll(rec.writeInnerRecords(lineEnding));
                }
                continue;
            }
            rec = this.getRecord(id);
            try {
                out.add(rec.write() + lineEnding);
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Erro ao tentar escrever o registro \"%s\".", rec.getName()), e);
            }
            if (!rec.isHeadOfGroup() || !rec.hasInnerRecords()) continue;
            out.addAll(rec.writeInnerRecords(lineEnding));
        }
        return out;
    }

    @Override
    public IFlatFile<IRecord> addRecord(IRecord record) {
        if (Objects.isNotNull(record)) {
            Record rec = (Record)Record.class.cast(record);
            this.addRecord(rec);
        }
        return this;
    }

    @Override
    public Collection<IRecord> getRecords(String idName) {
        ArrayList<IRecord> secRecords = new ArrayList<IRecord>();
        if (StringUtils.isNotBlank((CharSequence)idName) && this.isRepitable(idName) && !this.records.isEmpty()) {
            for (Record rec : this.records) {
                if (!idName.equals(rec.getName())) continue;
                secRecords.add(rec);
            }
        }
        return secRecords;
    }

    @Override
    public IFlatFile<IRecord> addAllRecords(Collection<IRecord> records) {
        throw new UnsupportedOperationException("AINDA N\u00c3O IMPLEMENTADO!");
    }

    @Override
    public IFlatFile<IRecord> addRecords(String idName, Collection<IRecord> records) {
        throw new UnsupportedOperationException("AINDA N\u00c3O IMPLEMENTADO!");
    }

    @Override
    public Collection<IRecord> getAllRecords() {
        throw new UnsupportedOperationException("AINDA N\u00c3O IMPLEMENTADO!");
    }

    @Override
    public IRecord removeRecord(String idName) {
        throw new UnsupportedOperationException("AINDA N\u00c3O IMPLEMENTADO!");
    }

    @Override
    public IFlatFile<IRecord> setAllRecords(Collection<IRecord> records) {
        throw new UnsupportedOperationException("AINDA N\u00c3O IMPLEMENTADO!");
    }

    @Override
    public IFlatFile<IRecord> setRecords(String idName, Collection<IRecord> records) {
        throw new UnsupportedOperationException("AINDA N\u00c3O IMPLEMENTADO!");
    }

    public Set<String> getRepitablesRecords() {
        return this.repitablesRecords;
    }

    public void setRepitablesRecords(Set<String> repitablesRecords) {
        this.repitablesRecords = repitablesRecords;
    }

    public List<String> getRecordsOrder() {
        return this.recordsOrder;
    }

    public void setRecordsOrder(List<String> recordsOrder) {
        this.recordsOrder = recordsOrder;
    }
}

