/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.texgit;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jrimum.texgit.BlockOfFields;
import org.jrimum.texgit.Field;
import org.jrimum.texgit.FixedField;
import org.jrimum.texgit.IField;
import org.jrimum.texgit.IFixedField;
import org.jrimum.texgit.IRecord;
import org.jrimum.texgit.IRecordFactory;
import org.jrimum.utilix.Objects;

public class Record
extends BlockOfFields
implements IRecord {
    protected String name;
    protected String description;
    protected FixedField<String> idType;
    protected FixedField<Long> sequencialNumber;
    protected boolean headOfGroup;
    protected List<IRecord> innerRecords;
    protected Set<String> repitablesRecords;
    protected List<String> declaredInnerRecords;

    public Record() {
    }

    public Record(Integer length, Integer size) {
        super(length, size);
    }

    @Override
    public Record clone() throws CloneNotSupportedException {
        return (Record)super.clone();
    }

    public FixedField<String> readID(String lineRecord) {
        Field ffID = null;
        try {
            ffID = this.getIdType().clone();
            ffID.setName("");
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException(String.format("Quebra de contrato [%s] n\u00e3o suporta clonagem!", (Object[])Objects.whenNull(ffID, "FixedField", ffID.getClass())), e);
        }
        this.getIdType().read(lineRecord.substring(this.getIdPosition(), this.getIdPosition() + this.getIdType().getFixedLength()));
        return ffID;
    }

    public FixedField<String> getId(String lineRecord) {
        Field ffID = null;
        try {
            ffID = this.getIdType().clone();
            ffID.setName("");
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException(String.format("Quebra de contrato [%s] n\u00e3o suporta clonagem!", (Object[])Objects.whenNull(ffID, "FixedField", ffID.getClass())), e);
        }
        ((FixedField)ffID).read(lineRecord.substring(this.getIdPosition(), this.getIdPosition() + this.getIdType().getFixedLength()));
        return ffID;
    }

    public FixedField<String> get(FixedField ff, String lineRecord) {
        if (ff == null) {
            return null;
        }
        try {
            ff = ((FixedField)ff).clone();
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException(String.format("Quebra de contrato [%s] n\u00e3o suporta clonagem!", (Object[])Objects.whenNull(ff, "FixedField", ff.getClass())), e);
        }
        int position = this.getPosition((FixedField)ff);
        ((FixedField)ff).read(lineRecord.substring(position, position + ((FixedField)ff).getFixedLength()));
        return ff;
    }

    public IFixedField<?> getField(String fieldName) {
        FixedField field = null;
        if (StringUtils.isNotBlank((CharSequence)fieldName) && !this.getFields().isEmpty()) {
            for (FixedField ff : this.getFields()) {
                if (!ff.getName().equals(fieldName)) continue;
                field = ff;
                break;
            }
        }
        return field;
    }

    public boolean isMyField(String idName) {
        boolean is = false;
        if (StringUtils.isNotBlank((CharSequence)idName) && !this.getFields().isEmpty()) {
            for (IField f : this.getFields()) {
                if (!idName.equals(f.getName())) continue;
                is = true;
                break;
            }
        }
        return is;
    }

    public int getPosition(FixedField f) {
        int pos = -1;
        if (f != null) {
            FixedField ff;
            pos = 0;
            Iterator iterator = this.getFields().iterator();
            while (iterator.hasNext() && !(ff = (FixedField)iterator.next()).getName().equals(f.getName())) {
                pos += ff.getFixedLength().intValue();
            }
        }
        return pos;
    }

    private int getIdPosition() {
        FixedField ff;
        int pos = 0;
        Iterator iterator = this.getFields().iterator();
        while (iterator.hasNext() && !(ff = (FixedField)iterator.next()).getName().equals(this.idType.getName())) {
            pos += ff.getFixedLength().intValue();
        }
        return pos;
    }

    public int readInnerRecords(List<String> lines, int lineIndex, IRecordFactory<Record> iFactory) {
        return this.readInnerRecords(this, lines, lineIndex, iFactory);
    }

    private int readInnerRecords(Record record, List<String> lines, int lineIndex, IRecordFactory<Record> iFactory) {
        if (Objects.isNotNull(record) && Objects.isNotNull(record.getDeclaredInnerRecords()) && !record.getDeclaredInnerRecords().isEmpty()) {
            boolean read = true;
            String line = null;
            FixedField<String> typeRecord = null;
            Record innerRec = null;
            for (String id : record.getDeclaredInnerRecords()) {
                innerRec = iFactory.create(id);
                try {
                    if (this.isRepitable(id)) {
                        while (read) {
                            if (Objects.isNull(innerRec)) {
                                innerRec = iFactory.create(id);
                            }
                            if (lineIndex < lines.size()) {
                                line = lines.get(lineIndex);
                            }
                            typeRecord = innerRec.readID(line);
                            read = ((String)innerRec.getIdType().getValue()).equals(typeRecord.getValue()) && lineIndex < lines.size();
                            if (!read) continue;
                            innerRec.read(line);
                            ++lineIndex;
                            record.addInnerRecord(innerRec);
                            if (innerRec.isHeadOfGroup()) {
                                innerRec.readInnerRecords(lines, lineIndex, iFactory);
                            }
                            innerRec = null;
                        }
                        continue;
                    }
                    if (lineIndex >= lines.size()) continue;
                    line = lines.get(lineIndex);
                    typeRecord = innerRec.readID(line);
                    if (!((String)innerRec.getIdType().getValue()).equals(typeRecord.getValue())) continue;
                    innerRec.read(line);
                    ++lineIndex;
                    record.addInnerRecord(innerRec);
                    if (innerRec.isHeadOfGroup()) {
                        innerRec.readInnerRecords(lines, lineIndex, iFactory);
                    }
                    innerRec = null;
                }
                catch (Exception e) {
                    throw new IllegalStateException(String.format("Erro ao tentar ler o registro \"%s\".", innerRec.getName()), e);
                }
            }
        }
        return lineIndex;
    }

    public List<String> writeInnerRecords() {
        return this.writeInnerRecords(this, "");
    }

    public List<String> writeInnerRecords(String lineEnding) {
        return this.writeInnerRecords(this, lineEnding);
    }

    private List<String> writeInnerRecords(Record record, String lineEnding) {
        ArrayList<String> out = new ArrayList<String>(record.getInnerRecords().size());
        for (String id : this.getDeclaredInnerRecords()) {
            if (this.isRepitable(id)) {
                for (Record rec : this.getRecords(id)) {
                    try {
                        out.add(rec.write() + lineEnding);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(String.format("Erro ao tentar escrever o registro \"%s\".", rec.getName()), e);
                    }
                    if (!rec.isHeadOfGroup()) continue;
                    out.addAll(rec.writeInnerRecords());
                }
                continue;
            }
            Record rec = this.getRecord(id);
            try {
                out.add(rec.write() + lineEnding);
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Erro ao tentar escrever o registro \"%s\".", rec.getName()), e);
            }
            if (!rec.isHeadOfGroup()) continue;
            out.addAll(rec.writeInnerRecords());
        }
        return out;
    }

    public Record getRecord(String idName) {
        Record record = null;
        if (StringUtils.isNotBlank((CharSequence)idName) && !this.isRepitable(idName) && !this.getInnerRecords().isEmpty()) {
            for (IRecord iRec : this.getInnerRecords()) {
                Record rec = (Record)iRec;
                if (!idName.equals(rec.getName())) continue;
                record = rec;
            }
        }
        return record;
    }

    public List<Record> getRecords(String idName) {
        ArrayList<Record> secRecords = new ArrayList<Record>();
        if (StringUtils.isNotBlank((CharSequence)idName) && this.isRepitable(idName) && !this.getInnerRecords().isEmpty()) {
            for (IRecord iRec : this.getInnerRecords()) {
                Record rec = (Record)iRec;
                if (!idName.equals(rec.getName())) continue;
                secRecords.add(rec);
            }
        }
        return secRecords;
    }

    public boolean isRepitable(String idName) {
        return Objects.isNotNull(this.repitablesRecords) && !this.repitablesRecords.isEmpty() && this.repitablesRecords.contains(idName);
    }

    public boolean isMyRecord(String idName) {
        boolean is = false;
        if (StringUtils.isNotBlank((CharSequence)idName) && !this.getDeclaredInnerRecords().isEmpty() && this.getDeclaredInnerRecords().contains(idName)) {
            is = true;
        }
        return is;
    }

    @Override
    public IRecord addInnerRecord(IRecord record) {
        if (Objects.isNotNull(record)) {
            if (Objects.isNull(this.innerRecords)) {
                this.innerRecords = new ArrayList<IRecord>();
            }
            if (this.isMyRecord(((Record)Record.class.cast(record)).getName())) {
                this.innerRecords.add(record);
            } else {
                throw new IllegalArgumentException("Record fora de scopo!");
            }
        }
        return this;
    }

    @Override
    public List<IRecord> getInnerRecords() {
        return this.innerRecords;
    }

    @Override
    public <G> G getValue(String fieldName) {
        G value = null;
        IFixedField<?> f = this.getField(fieldName);
        if (Objects.isNotNull(f)) {
            value = f.getValue();
        }
        return value;
    }

    @Override
    public <G> IRecord setValue(String fieldName, G value) {
        IFixedField<?> f = this.getField(fieldName);
        if (Objects.isNotNull(f)) {
            f.setValue(value);
        }
        return this;
    }

    public boolean hasInnerRecords() {
        return this.getInnerRecords() != null && !this.getInnerRecords().isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public FixedField<String> getIdType() {
        return this.idType;
    }

    public void setIdType(FixedField<String> idType) {
        this.idType = idType;
    }

    public FixedField<Long> getSequencialNumber() {
        return this.sequencialNumber;
    }

    public void setSequencialNumber(FixedField<Long> sequencialNumber) {
        this.sequencialNumber = sequencialNumber;
    }

    public boolean isHeadOfGroup() {
        return this.headOfGroup;
    }

    public void setHeadOfGroup(boolean headOfGroup) {
        this.headOfGroup = headOfGroup;
    }

    public List<String> getDeclaredInnerRecords() {
        return this.declaredInnerRecords;
    }

    public void setDeclaredInnerRecords(List<String> declaredInnerRecords) {
        this.declaredInnerRecords = declaredInnerRecords;
    }

    public Set<String> getRepitablesRecords() {
        return this.repitablesRecords;
    }

    public void setRepitablesRecords(Set<String> repitablesRecords) {
        this.repitablesRecords = repitablesRecords;
    }
}

