/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.texgit;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jrimum.texgit.FixedFieldBuilder;
import org.jrimum.texgit.MetaField;
import org.jrimum.texgit.MetaOrderedField;
import org.jrimum.texgit.MetaRecord;
import org.jrimum.texgit.Record;
import org.jrimum.utilix.Objects;

class RecordBuilder {
    RecordBuilder() {
    }

    static Record build(MetaRecord metaRecord) {
        int strLength = RecordBuilder.getStringLength(metaRecord.getGroupOfFields().getFields());
        int fldSize = metaRecord.getGroupOfFields().getFields().size();
        MetaOrderedField id = metaRecord.getGroupOfFields().getIdType();
        MetaOrderedField sequencialNumber = metaRecord.getGroupOfFields().getSequencialNumber();
        if (Objects.isNotNull(id)) {
            ++fldSize;
            strLength += id.getLength();
        }
        if (Objects.isNotNull(sequencialNumber)) {
            ++fldSize;
            strLength += sequencialNumber.getLength();
        }
        Record record = new Record(strLength, fldSize);
        record.setName(metaRecord.getName());
        record.setDescription(metaRecord.getDescription());
        if (Objects.isNotNull(id)) {
            record.setIdType(FixedFieldBuilder.build(id));
            record.set(id.getPosition() - 1, record.getIdType());
        }
        if (Objects.isNotNull(sequencialNumber)) {
            record.setSequencialNumber(FixedFieldBuilder.build(sequencialNumber));
            record.set(sequencialNumber.getPosition() - 1, record.getSequencialNumber());
        }
        List<MetaField> fields = metaRecord.getGroupOfFields().getFields();
        for (MetaField mField : fields) {
            if (Objects.isNull(record.get(fields.indexOf(mField)))) {
                record.set(fields.indexOf(mField), FixedFieldBuilder.build(mField));
                continue;
            }
            if (Objects.isNull(record.get(fields.indexOf(mField) + 1))) {
                record.set(fields.indexOf(mField) + 1, FixedFieldBuilder.build(mField));
                continue;
            }
            record.set(fields.indexOf(mField) + 2, FixedFieldBuilder.build(mField));
        }
        if (Objects.isNotNull(metaRecord.getGroupOfInnerRecords())) {
            record.setHeadOfGroup(true);
            record.setDeclaredInnerRecords(new ArrayList<String>(metaRecord.getGroupOfInnerRecords().getRecords().size()));
            record.setRepitablesRecords(new HashSet<String>());
            List<MetaRecord> metaInnerRecords = metaRecord.getGroupOfInnerRecords().getRecords();
            for (MetaRecord mRecord : metaInnerRecords) {
                record.getDeclaredInnerRecords().add(mRecord.getName());
                if (!mRecord.isRepeatable()) continue;
                record.getRepitablesRecords().add(mRecord.getName());
            }
        } else {
            record.setHeadOfGroup(false);
        }
        return record;
    }

    private static int getStringLength(List<MetaField> fields) {
        int length = 0;
        for (MetaField mField : fields) {
            length += mField.getLength();
        }
        return length;
    }
}

