/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.texgit;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jrimum.texgit.IRecordFactory;
import org.jrimum.texgit.MetaRecord;
import org.jrimum.texgit.Record;
import org.jrimum.texgit.RecordBuilder;
import org.jrimum.utilix.Objects;

public class RecordFactory
implements IRecordFactory<Record> {
    private Map<String, MetaRecord> name_record;

    RecordFactory(List<MetaRecord> metaRecords) {
        if (Objects.isNotNull(metaRecords) && !metaRecords.isEmpty()) {
            this.name_record = new HashMap<String, MetaRecord>(metaRecords.size());
            for (MetaRecord mRecord : metaRecords) {
                this.name_record.put(mRecord.getName(), mRecord);
                if (!Objects.isNotNull(mRecord.getGroupOfInnerRecords())) continue;
                this.loadInnerRecords(this.name_record, mRecord.getGroupOfInnerRecords().getRecords());
            }
        }
    }

    private void loadInnerRecords(Map<String, MetaRecord> name_record, List<MetaRecord> innerMetaRecords) {
        if (Objects.isNotNull(innerMetaRecords) && !innerMetaRecords.isEmpty()) {
            for (MetaRecord iMetaRecord : innerMetaRecords) {
                name_record.put(iMetaRecord.getName(), iMetaRecord);
                if (!Objects.isNotNull(iMetaRecord.getGroupOfInnerRecords())) continue;
                this.loadInnerRecords(name_record, iMetaRecord.getGroupOfInnerRecords().getRecords());
            }
        }
    }

    @Override
    public Record create(String name) {
        Record record = null;
        if (StringUtils.isNotBlank((CharSequence)name) && this.name_record.containsKey(name)) {
            record = RecordBuilder.build(this.name_record.get(name));
        }
        return record;
    }
}

