/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.texgit;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.jrimum.texgit.IFlatFile;
import org.jrimum.texgit.IRecord;
import org.jrimum.texgit.TexgitException;
import org.jrimum.texgit.TexgitManager;
import org.jrimum.utilix.Objects;

public final class Texgit {
    public static final IFlatFile<IRecord> createFlatFile(String xmlDefFilePath) throws TexgitException {
        try {
            if (StringUtils.isNotBlank((CharSequence)xmlDefFilePath)) {
                return Texgit.createFlatFile(new File(xmlDefFilePath));
            }
        }
        catch (Exception e) {
            throw new TexgitException(e);
        }
        return null;
    }

    public static final IFlatFile<IRecord> createFlatFile(File xmlDefFile) throws TexgitException {
        try {
            if (Objects.isNotNull(xmlDefFile)) {
                return Texgit.createFlatFile(new FileInputStream(xmlDefFile));
            }
        }
        catch (Exception e) {
            throw new TexgitException(e);
        }
        return null;
    }

    public static final IFlatFile<IRecord> createFlatFile(URL xmlDefUrl) throws TexgitException {
        try {
            if (Objects.isNotNull(xmlDefUrl)) {
                return TexgitManager.buildFlatFile(xmlDefUrl.openStream());
            }
        }
        catch (Exception e) {
            throw new TexgitException(e);
        }
        return null;
    }

    public static final IFlatFile<IRecord> createFlatFile(byte[] xmlDefBytes) throws TexgitException {
        try {
            if (Objects.isNotNull(xmlDefBytes)) {
                return TexgitManager.buildFlatFile(new ByteArrayInputStream(xmlDefBytes));
            }
        }
        catch (Exception e) {
            throw new TexgitException(e);
        }
        return null;
    }

    public static final IFlatFile<IRecord> createFlatFile(InputStream xmlDefStream) throws TexgitException {
        if (Objects.isNotNull(xmlDefStream)) {
            return TexgitManager.buildFlatFile(xmlDefStream);
        }
        return null;
    }
}

