/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.texgit;

import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.jrimum.texgit.MetaTexgit;
import org.jrimum.texgit.Texgit;
import org.jrimum.texgit.TexgitException;
import org.jrimum.texgit.TexgitLanguageException;
import org.jrimum.texgit.TexgitSchemaValidator;
import org.jrimum.utilix.ClassLoaders;
import org.jrimum.utilix.Objects;
import org.xml.sax.SAXException;

class TexgitXmlReader {
    TexgitXmlReader() {
    }

    public static MetaTexgit parse(InputStream xmlDefStream) throws TexgitException {
        MetaTexgit txg = null;
        if (Objects.isNotNull(xmlDefStream)) {
            try {
                JAXBContext aJaxbContext = JAXBContext.newInstance((Class[])new Class[]{MetaTexgit.class});
                Unmarshaller aUnmarshaller = aJaxbContext.createUnmarshaller();
                SchemaFactory aSchemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = aSchemaFactory.newSchema(ClassLoaders.getResource("TexgitSchema.xsd", Texgit.class));
                aUnmarshaller.setSchema(schema);
                aUnmarshaller.setEventHandler((ValidationEventHandler)new TexgitSchemaValidator());
                txg = (MetaTexgit)aUnmarshaller.unmarshal(xmlDefStream);
            }
            catch (SAXException e) {
                throw new TexgitLanguageException(e);
            }
            catch (JAXBException e) {
                throw new TexgitLanguageException(e);
            }
        }
        return txg;
    }
}

